/*
 * Decompiled with CFR 0.152.
 */
package de.saly.kafka.crypto;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;

public abstract class SerdeCryptoBase {
    public static final String CRYPTO_RSA_PRIVATEKEY_FILEPATH = "crypto.rsa.privatekey.filepath";
    public static final String CRYPTO_RSA_PUBLICKEY_FILEPATH = "crypto.rsa.publickey.filepath";
    public static final String CRYPTO_HASH_METHOD = "crypto.hash_method";
    public static final String CRYPTO_IGNORE_DECRYPT_FAILURES = "crypto.ignore_decrypt_failures";
    public static final String CRYPTO_AES_KEY_LEN = "crypto.aes.key_len";
    static final byte[] MAGIC_BYTES = new byte[]{-33, -69};
    protected static final String DEFAULT_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final Map<String, byte[]> aesKeyCache = new HashMap<String, byte[]>();
    private static final int MAGIC_BYTES_LENGTH = MAGIC_BYTES.length;
    private static final int HEADER_LENGTH = MAGIC_BYTES_LENGTH + 3;
    private static final String AES = "AES";
    private static final String RSA = "RSA";
    private static final String RSA_TRANFORMATION = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static final int RSA_MULTIPLICATOR = 128;
    private int opMode;
    private String hashMethod = "SHA-256";
    private int aesKeyLen = 128;
    private boolean ignoreDecryptFailures = false;
    private ProducerCryptoBundle producerCryptoBundle = null;
    private ConsumerCryptoBundle consumerCryptoBundle = null;

    protected SerdeCryptoBase() {
    }

    protected void init(int opMode, Map<String, ?> configs, boolean isKey) throws KafkaException {
        String aesKeyLenProperty;
        String ignoreDecryptFailuresProperty;
        this.opMode = opMode;
        String hashMethodProperty = (String)configs.get(CRYPTO_HASH_METHOD);
        if (hashMethodProperty != null && hashMethodProperty.length() != 0) {
            this.hashMethod = hashMethodProperty;
        }
        if ((ignoreDecryptFailuresProperty = (String)configs.get(CRYPTO_IGNORE_DECRYPT_FAILURES)) != null && ignoreDecryptFailuresProperty.length() != 0) {
            this.ignoreDecryptFailures = Boolean.parseBoolean(ignoreDecryptFailuresProperty);
        }
        if ((aesKeyLenProperty = (String)configs.get(CRYPTO_AES_KEY_LEN)) != null && aesKeyLenProperty.length() != 0) {
            this.aesKeyLen = Integer.parseInt(aesKeyLenProperty);
            if (this.aesKeyLen < 128 || this.aesKeyLen % 8 != 0) {
                throw new KafkaException("Invalid aes key size, should be 128, 192 or 256");
            }
        }
        try {
            if (opMode == 2) {
                String rsaPrivateKeyFile = (String)configs.get(CRYPTO_RSA_PRIVATEKEY_FILEPATH);
                this.consumerCryptoBundle = new ConsumerCryptoBundle(SerdeCryptoBase.createRSAPrivateKey(SerdeCryptoBase.readBytesFromFile(rsaPrivateKeyFile)));
            } else {
                String rsaPublicKeyFile = (String)configs.get(CRYPTO_RSA_PUBLICKEY_FILEPATH);
                this.producerCryptoBundle = new ProducerCryptoBundle(SerdeCryptoBase.createRSAPublicKey(SerdeCryptoBase.readBytesFromFile(rsaPublicKeyFile)));
            }
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }

    protected byte[] crypt(byte[] array) throws KafkaException {
        if (array == null || array.length == 0) {
            return array;
        }
        if (this.opMode == 2) {
            return this.consumerCryptoBundle.aesDecrypt(array);
        }
        return this.producerCryptoBundle.aesEncrypt(array);
    }

    protected void newKey() {
        try {
            this.producerCryptoBundle.newKey();
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }

    protected <T> T newInstance(Map<String, ?> map, String key, Class<T> klass) throws KafkaException {
        Object val = map.get(key);
        if (val == null) {
            throw new KafkaException("No value for '" + key + "' found");
        }
        if (val instanceof String) {
            try {
                return (T)Utils.newInstance(Class.forName((String)val));
            }
            catch (Exception e) {
                throw new KafkaException((Throwable)e);
            }
        }
        if (val instanceof Class) {
            return (T)Utils.newInstance((Class)((Class)val));
        }
        throw new KafkaException("Unexpected type '" + val.getClass() + "' for '" + key + "'");
    }

    private static PrivateKey createRSAPrivateKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (encodedKey == null || encodedKey.length == 0) {
            throw new IllegalArgumentException("Key bytes must not be null or empty");
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        return kf.generatePrivate(spec);
    }

    private static SecretKey createAESSecretKey(byte[] encodedKey) {
        if (encodedKey == null || encodedKey.length == 0) {
            throw new IllegalArgumentException("Key bytes must not be null or empty");
        }
        return new SecretKeySpec(encodedKey, AES);
    }

    private static PublicKey createRSAPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (encodedKey == null || encodedKey.length == 0) {
            throw new IllegalArgumentException("Key bytes must not be null or empty");
        }
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedKey);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        return kf.generatePublic(spec);
    }

    private static byte[] readBytesFromFile(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("Filename must not be null");
        }
        File f = new File(filename);
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        byte[] bytes = new byte[(int)f.length()];
        dis.readFully(bytes);
        dis.close();
        return bytes;
    }

    private byte[] hash(byte[] toHash) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.hashMethod);
            md.update(toHash);
            return md.digest();
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private static byte[] crypt(Cipher c, byte[] plain) throws IllegalBlockSizeException, BadPaddingException {
        return c.doFinal(plain);
    }

    private static byte[] crypt(Cipher c, byte[] plain, int offset, int len) throws IllegalBlockSizeException, BadPaddingException {
        return c.doFinal(plain, offset, len);
    }

    public static byte[] concatenate(byte[] a, byte[] b, byte[] c, byte[] d, byte[] e, byte[] f) {
        if (a != null && b != null && c != null && d != null && e != null && f != null) {
            byte[] rv = new byte[a.length + b.length + c.length + d.length + e.length + f.length];
            System.arraycopy(a, 0, rv, 0, a.length);
            System.arraycopy(b, 0, rv, a.length, b.length);
            System.arraycopy(c, 0, rv, a.length + b.length, c.length);
            System.arraycopy(d, 0, rv, a.length + b.length + c.length, d.length);
            System.arraycopy(e, 0, rv, a.length + b.length + c.length + d.length, e.length);
            System.arraycopy(f, 0, rv, a.length + b.length + c.length + d.length + e.length, f.length);
            return rv;
        }
        throw new IllegalArgumentException("arrays must not be null");
    }

    private class ProducerCryptoBundle {
        private ThreadLocal<ThreadAwareKeyInfo> keyInfo = new ThreadLocal<ThreadAwareKeyInfo>(){

            @Override
            protected ThreadAwareKeyInfo initialValue() {
                try {
                    return new ThreadAwareKeyInfo(ProducerCryptoBundle.this.publicKey);
                }
                catch (Exception e) {
                    throw new KafkaException((Throwable)e);
                }
            }
        };
        private final PublicKey publicKey;

        private ProducerCryptoBundle(PublicKey publicKey) throws Exception {
            this.publicKey = publicKey;
        }

        private void newKey() throws Exception {
            this.keyInfo.remove();
        }

        private byte[] aesEncrypt(byte[] plain) throws KafkaException {
            ThreadAwareKeyInfo ki = this.keyInfo.get();
            try {
                byte[] aesIv = new byte[16];
                ki.random.nextBytes(aesIv);
                ki.aesCipher.init(1, (Key)ki.aesKey, new IvParameterSpec(aesIv));
                return SerdeCryptoBase.concatenate(MAGIC_BYTES, new byte[]{(byte)ki.aesHash.length, (byte)(ki.rsaEncyptedAesKey.length / 128), (byte)aesIv.length}, ki.aesHash, ki.rsaEncyptedAesKey, aesIv, SerdeCryptoBase.crypt(ki.aesCipher, plain));
            }
            catch (Exception e) {
                throw new KafkaException((Throwable)e);
            }
        }
    }

    private class ThreadAwareKeyInfo {
        private final SecretKey aesKey;
        private final byte[] aesHash;
        private final byte[] rsaEncyptedAesKey;
        private final Cipher rsaCipher;
        private final Cipher aesCipher;
        private final SecureRandom random = new SecureRandom();

        protected ThreadAwareKeyInfo(PublicKey publicKey) throws Exception {
            byte[] aesKeyBytes = new byte[SerdeCryptoBase.this.aesKeyLen / 8];
            this.random.nextBytes(aesKeyBytes);
            this.aesCipher = Cipher.getInstance(SerdeCryptoBase.DEFAULT_TRANSFORMATION);
            this.aesKey = SerdeCryptoBase.createAESSecretKey(aesKeyBytes);
            this.aesHash = SerdeCryptoBase.this.hash(aesKeyBytes);
            this.rsaCipher = Cipher.getInstance(SerdeCryptoBase.RSA_TRANFORMATION);
            this.rsaCipher.init(1, publicKey);
            this.rsaEncyptedAesKey = SerdeCryptoBase.crypt(this.rsaCipher, aesKeyBytes);
        }
    }

    private class ConsumerCryptoBundle {
        private Cipher rsaDecrypt;
        final Cipher aesDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");

        private ConsumerCryptoBundle(PrivateKey privateKey) throws Exception {
            this.rsaDecrypt = Cipher.getInstance(SerdeCryptoBase.RSA_TRANFORMATION);
            this.rsaDecrypt.init(2, privateKey);
        }

        private byte[] aesDecrypt(byte[] encrypted) throws KafkaException {
            try {
                if (encrypted[0] == MAGIC_BYTES[0] && encrypted[1] == MAGIC_BYTES[1]) {
                    byte hashLen = encrypted[2];
                    byte rsaFactor = encrypted[3];
                    byte ivLen = encrypted[4];
                    int offset = HEADER_LENGTH + hashLen + rsaFactor * 128 + ivLen;
                    String aesHash = DatatypeConverter.printHexBinary((byte[])Arrays.copyOfRange(encrypted, HEADER_LENGTH, HEADER_LENGTH + hashLen));
                    byte[] iv = Arrays.copyOfRange(encrypted, HEADER_LENGTH + hashLen + rsaFactor * 128, HEADER_LENGTH + hashLen + rsaFactor * 128 + ivLen);
                    byte[] aesKey = (byte[])aesKeyCache.get(aesHash);
                    if (aesKey != null) {
                        this.aesDecrypt.init(2, (Key)SerdeCryptoBase.createAESSecretKey(aesKey), new IvParameterSpec(iv));
                        return SerdeCryptoBase.crypt(this.aesDecrypt, encrypted, offset, encrypted.length - offset);
                    }
                    byte[] rsaEncryptedAesKey = Arrays.copyOfRange(encrypted, HEADER_LENGTH + hashLen, HEADER_LENGTH + hashLen + rsaFactor * 128);
                    aesKey = SerdeCryptoBase.crypt(this.rsaDecrypt, rsaEncryptedAesKey);
                    this.aesDecrypt.init(2, (Key)SerdeCryptoBase.createAESSecretKey(aesKey), new IvParameterSpec(iv));
                    aesKeyCache.put(aesHash, aesKey);
                    return SerdeCryptoBase.crypt(this.aesDecrypt, encrypted, offset, encrypted.length - offset);
                }
                return encrypted;
            }
            catch (Exception e) {
                if (SerdeCryptoBase.this.ignoreDecryptFailures) {
                    return encrypted;
                }
                throw new KafkaException("Decrypt failed", (Throwable)e);
            }
        }
    }
}

