/*
 * Decompiled with CFR 0.152.
 */
package de.saly.kafka.crypto;

import de.saly.kafka.crypto.SerdeCryptoBase;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.serialization.Serializer;

public class EncryptingSerializer<T>
extends SerdeCryptoBase
implements Serializer<T> {
    public static final String CRYPTO_VALUE_SERIALIZER = "crypto.wrapped_serializer";
    public static final String CRYPTO_NEW_KEY_MSG_INTERVAL = "crypto.new_key_msg_interval";
    public int msgInterval = -1;
    private Serializer<T> inner;
    private final AtomicInteger msg = new AtomicInteger();

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner = this.newInstance(configs, CRYPTO_VALUE_SERIALIZER, Serializer.class);
        this.inner.configure(configs, isKey);
        this.init(1, configs, isKey);
        String msgIntervalProperty = (String)configs.get(CRYPTO_NEW_KEY_MSG_INTERVAL);
        if (msgIntervalProperty != null && msgIntervalProperty.length() > 0) {
            this.msgInterval = Integer.parseInt(msgIntervalProperty);
            if (this.msgInterval < 1) {
                this.msgInterval = -1;
            }
        }
    }

    public byte[] serialize(String topic, T data) {
        if (this.msgInterval > 0 && this.msg.compareAndSet(this.msgInterval, 0)) {
            this.newKey();
        } else if (this.msgInterval > 0) {
            this.msg.incrementAndGet();
        }
        return this.crypt(this.inner.serialize(topic, data));
    }

    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    @Override
    public void newKey() {
        super.newKey();
    }
}

