/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import com.sun.mail.pop3.POP3Store;
import de.saly.javamail.mock2.MailboxFolder;
import de.saly.javamail.mock2.MockMailbox;
import de.saly.javamail.mock2.POP3MockFolder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POP3MockStore
extends POP3Store {
    private volatile boolean connected;
    private MockMailbox mailbox;
    private final UUID objectId = UUID.randomUUID();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public POP3MockStore(Session session, URLName urlname) {
        this(session, urlname, "pop3", false);
    }

    public POP3MockStore(Session session, URLName url, String name, boolean isSSL) {
        super(session, url, name, isSSL);
        this.logger.debug("Created " + this.objectId);
    }

    public Map capabilities() throws MessagingException {
        return new HashMap();
    }

    public synchronized void close() throws MessagingException {
        this.connected = false;
        this.mailbox = null;
        this.notifyConnectionListeners(3);
        this.logger.debug("Closed " + this.objectId);
    }

    public synchronized void connect() throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(this.url.getHost(), this.url.getPort(), this.url.getUsername(), this.url.getPassword());
    }

    public synchronized void connect(String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(this.url.getHost(), this.url.getPort(), user, password);
    }

    public synchronized void connect(String host, String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(host, this.url.getPort(), user, password);
    }

    public synchronized Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return super.getDefaultFolder();
    }

    public synchronized Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        if ("inbox".equalsIgnoreCase(name)) {
            return new POP3MockFolder(this, this.mailbox.getInbox());
        }
        return new POP3MockFolder(this, new MailboxFolder(name, this.mailbox, false));
    }

    public synchronized Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return this.getFolder(url.getFile());
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    protected synchronized void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }

    protected synchronized boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        this.logger.debug("Connect to " + user + " (" + this.objectId + ")");
        this.mailbox = MockMailbox.get(user);
        if (this.mailbox.getInbox().isSimulateError()) {
            throw new MessagingException("Simulated error connecting to mailbox of " + user);
        }
        this.connected = true;
        return true;
    }

    synchronized Session getSession() {
        return this.session;
    }
}

