/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import com.sun.mail.pop3.POP3MockFolder0;
import de.saly.javamail.mock2.MailboxFolder;
import de.saly.javamail.mock2.MockMessage;
import de.saly.javamail.mock2.POP3MockStore;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POP3MockFolder
extends POP3MockFolder0
implements MailboxFolder.MailboxEventListener {
    private final MailboxFolder mailboxFolder;
    private final UUID objectId = UUID.randomUUID();
    private volatile boolean opened;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected POP3MockFolder(POP3MockStore store, MailboxFolder mailboxFolder) {
        super(store);
        this.logger.warn("POP3 Mock Store in use");
        System.out.println("POP3 Mock Store in use");
        this.mailboxFolder = mailboxFolder;
        this.mailboxFolder.addMailboxEventListener(this);
    }

    public synchronized void close(boolean expunge) throws MessagingException {
        this.checkOpened();
        if (expunge) {
            this.mailboxFolder.expunge();
        }
        this.opened = false;
        this.logger.debug("Folder closed " + this.objectId);
        this.notifyConnectionListeners(3);
    }

    public void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
    }

    @Override
    public void folderCreated(MailboxFolder mf) {
    }

    @Override
    public void folderDeleted(MailboxFolder mf) {
    }

    @Override
    public void folderRenamed(String from, MailboxFolder to) {
    }

    public synchronized Message getMessage(int msgnum) throws MessagingException {
        this.checkOpened();
        return new MockMessage(this.mailboxFolder.getByMsgNum(msgnum), (Folder)this);
    }

    public synchronized int getMessageCount() throws MessagingException {
        return this.mailboxFolder.getMessageCount();
    }

    public synchronized Message[] getMessages() throws MessagingException {
        this.checkOpened();
        ArrayList<MockMessage> messages = new ArrayList<MockMessage>();
        for (int i = 1; i <= this.mailboxFolder.getMessageCount(); ++i) {
            Message m = this.mailboxFolder.getByMsgNum(i);
            messages.add(new MockMessage(m, (Folder)this));
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public synchronized Message[] getMessages(int low, int high) throws MessagingException {
        this.checkOpened();
        ArrayList<MockMessage> messages = new ArrayList<MockMessage>();
        for (int i = low; i <= high; ++i) {
            Message m = this.mailboxFolder.getByMsgNum(i);
            messages.add(new MockMessage(m, (Folder)this));
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public synchronized Message[] getMessages(int[] msgnums) throws MessagingException {
        this.checkOpened();
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        for (int value : msgnums) {
            idlist.add(value);
        }
        ArrayList<MockMessage> messages = new ArrayList<MockMessage>();
        for (int i = 1; i <= this.mailboxFolder.getMessageCount(); ++i) {
            if (!idlist.contains(new Integer(i))) continue;
            Message m = this.mailboxFolder.getByMsgNum(i);
            messages.add(new MockMessage(m, (Folder)this));
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public synchronized int getSize() throws MessagingException {
        this.checkOpened();
        return this.mailboxFolder.getSizeInBytes();
    }

    public synchronized int[] getSizes() throws MessagingException {
        this.checkOpened();
        int count = this.getMessageCount();
        int[] sizes = new int[count];
        for (int i = 1; i <= count; ++i) {
            sizes[i - 1] = this.getMessage(i).getSize();
        }
        return sizes;
    }

    public synchronized String getUID(Message msg) throws MessagingException {
        this.checkOpened();
        return String.valueOf(((MockMessage)msg).getMockid());
    }

    public boolean isOpen() {
        return this.opened;
    }

    public InputStream listCommand() throws MessagingException, IOException {
        throw new MethodNotSupportedException();
    }

    @Override
    public void messageAdded(MailboxFolder mf, MockMessage msg) {
    }

    @Override
    public void messageChanged(MailboxFolder mf, MockMessage msg, boolean headerChanged, boolean flagsChanged) {
        this.notifyMessageChangedListeners(1, (Message)msg);
    }

    @Override
    public void messageExpunged(MailboxFolder mf, MockMessage msg, boolean removed) {
    }

    public synchronized void open(int mode) throws MessagingException {
        this.checkClosed();
        this.opened = true;
        this.logger.debug("Open " + this.objectId);
        this.notifyConnectionListeners(1);
    }

    @Override
    public void uidInvalidated() {
    }

    protected synchronized void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder " + this.objectId);
        }
    }

    protected synchronized void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            throw new IllegalStateException("This operation is not allowed on a closed folder " + this.objectId);
        }
    }
}

