/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import com.sun.mail.imap.IMAPStore;
import de.saly.javamail.mock2.IMAPDefaultMockFolder;
import de.saly.javamail.mock2.IMAPMockFolder;
import de.saly.javamail.mock2.MockMailbox;
import java.util.Map;
import java.util.UUID;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Quota;
import javax.mail.Session;
import javax.mail.URLName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPMockStore
extends IMAPStore {
    private boolean connected;
    private MockMailbox mailbox;
    private final UUID objectId = UUID.randomUUID();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public IMAPMockStore(Session session, URLName urlname) {
        this(session, urlname, "imap", false);
    }

    public IMAPMockStore(Session session, URLName url, String name, boolean isSSL) {
        super(session, url, name, isSSL);
        this.logger.warn("IMAP Mock Store in use");
        System.out.println("IMAP Mock Store in use");
        this.logger.debug("Created " + this.objectId);
    }

    public synchronized void close() throws MessagingException {
        this.connected = false;
        this.notifyConnectionListeners(3);
        this.logger.debug("Closed " + this.objectId);
    }

    public void connect() throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(this.url.getHost(), this.url.getPort(), this.url.getUsername(), this.url.getPassword());
    }

    public void connect(String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(this.url.getHost(), this.url.getPort(), user, password);
    }

    public void connect(String host, String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(host, this.url.getPort(), user, password);
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new IMAPDefaultMockFolder(this, this.mailbox);
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        this.logger.debug("getFolder(" + name + ")");
        if ("inbox".equalsIgnoreCase(name)) {
            return new IMAPMockFolder(this, this.mailbox.getInbox());
        }
        return new IMAPMockFolder(this, this.mailbox.getRoot().getOrAddSubFolder(name));
    }

    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return this.getFolder(url.getFile());
    }

    public synchronized Quota[] getQuota(String root) throws MessagingException {
        throw new MessagingException("QUOTA not supported");
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        return super.getSharedNamespaces();
    }

    public Folder[] getUserNamespaces(String user) throws MessagingException {
        return super.getUserNamespaces(user);
    }

    public synchronized boolean hasCapability(String capability) throws MessagingException {
        return capability != null && capability.toLowerCase().startsWith("imap4");
    }

    public synchronized Map<String, String> id(Map<String, String> clientParams) throws MessagingException {
        throw new MessagingException("ID not supported");
    }

    public void idle() throws MessagingException {
        throw new MessagingException("IDLE not supported");
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void setQuota(Quota quota) throws MessagingException {
        throw new MessagingException("QUOTA not supported");
    }

    protected void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }

    protected boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        this.logger.debug("Connect to " + user + " (" + this.objectId + ")");
        this.mailbox = MockMailbox.get(user);
        if (this.mailbox.getInbox().isSimulateError()) {
            throw new MessagingException("Simulated error connecting to mailbox of " + user);
        }
        this.connected = true;
        return true;
    }

    Session getSession() {
        return this.session;
    }
}

