/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import com.sun.mail.iap.Response;
import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import de.saly.javamail.mock2.IMAPMockStore;
import de.saly.javamail.mock2.MailboxFolder;
import de.saly.javamail.mock2.MockMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPMockFolder
extends IMAPFolder
implements MailboxFolder.MailboxEventListener {
    private final MailboxFolder mailboxFolder;
    private final UUID objectId = UUID.randomUUID();
    private volatile boolean opened = false;
    private int openMode;
    private final IMAPMockStore store;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected IMAPMockFolder(IMAPMockStore store, MailboxFolder mailboxFolder) {
        super("DUMMY_NAME_WHICH_MUST_NOT_BE_VISIBLE", '/', (IMAPStore)store, Boolean.valueOf(false));
        this.mailboxFolder = mailboxFolder;
        this.mailboxFolder.addMailboxEventListener(this);
        this.store = store;
        this.logger.debug("Folder created " + this.objectId);
    }

    public void appendMessages(Message[] msgs) throws MessagingException {
        this.checkExists();
        for (Message m : msgs) {
            this.mailboxFolder.add((MimeMessage)m);
        }
        this.logger.debug("Append " + msgs.length + " to " + this.getFullName());
    }

    public AppendUID[] appendUIDMessages(Message[] msgs) throws MessagingException {
        AppendUID[] uids = new AppendUID[msgs.length];
        this.checkExists();
        int i = 0;
        for (Message m : msgs) {
            MockMessage mockMessage = (MockMessage)this.mailboxFolder.add((MimeMessage)m);
            uids[i++] = new AppendUID(this.mailboxFolder.getUidValidity(), mockMessage.getMockid());
        }
        this.logger.debug("Append " + msgs.length + " to " + this.getFullName());
        return uids;
    }

    public void close(boolean expunge) throws MessagingException {
        this.checkOpened();
        this.checkExists();
        if (expunge) {
            this.expunge();
        }
        this.opened = false;
        this.logger.debug("Folder " + this.getFullName() + " closed (" + this.objectId + ")");
        this.notifyConnectionListeners(3);
    }

    public boolean create(int type) throws MessagingException {
        if (this.exists()) {
            return true;
        }
        this.mailboxFolder.create();
        this.notifyFolderListeners(1);
        return this.mailboxFolder.isExists();
    }

    public boolean delete(boolean recurse) throws MessagingException {
        this.checkExists();
        this.checkClosed();
        this.mailboxFolder.deleteFolder(recurse);
        this.notifyFolderListeners(2);
        return true;
    }

    public Object doOptionalCommand(String err, IMAPFolder.ProtocolCommand cmd) throws MessagingException {
        throw new MessagingException("Optional command not supported: " + err);
    }

    public boolean exists() throws MessagingException {
        return this.mailboxFolder.isExists();
    }

    public Message[] expunge() throws MessagingException {
        this.checkExists();
        this.checkOpened();
        this.checkWriteMode();
        Message[] removed = this.wrap(this.mailboxFolder.expunge());
        if (removed.length > 0) {
            this.notifyMessageRemovedListeners(true, removed);
        }
        return removed;
    }

    public synchronized Message[] expunge(Message[] msgs) throws MessagingException {
        this.checkExists();
        this.checkOpened();
        this.checkWriteMode();
        Message[] removed = this.wrap(this.mailboxFolder.expunge(msgs));
        if (removed.length > 0) {
            this.notifyMessageRemovedListeners(true, removed);
        }
        return removed;
    }

    public synchronized void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
    }

    @Override
    public void folderCreated(MailboxFolder mf) {
    }

    @Override
    public void folderDeleted(MailboxFolder mf) {
    }

    @Override
    public void folderRenamed(String from, MailboxFolder to) {
    }

    public Folder getFolder(String name) throws MessagingException {
        this.logger.debug("getFolder(" + name + ") on " + this.getFullName());
        if ("inbox".equalsIgnoreCase(name)) {
            return new IMAPMockFolder(this.store, this.mailboxFolder.getMailbox().getInbox());
        }
        return new IMAPMockFolder(this.store, this.mailboxFolder.getOrAddSubFolder(name));
    }

    public synchronized String getFullName() {
        return this.mailboxFolder.getFullName();
    }

    public Message getMessage(int msgnum) throws MessagingException {
        this.checkExists();
        this.checkOpened();
        return new MockMessage(this.mailboxFolder.getByMsgNum(msgnum), (Folder)this);
    }

    public synchronized Message getMessageByUID(long uid) throws MessagingException {
        this.checkExists();
        this.checkOpened();
        return new MockMessage(this.mailboxFolder.getById(uid), (Folder)this);
    }

    public int getMessageCount() throws MessagingException {
        this.checkExists();
        return this.mailboxFolder.getMessageCount();
    }

    public Message[] getMessages(int low, int high) throws MessagingException {
        this.checkExists();
        this.checkOpened();
        ArrayList<MockMessage> messages = new ArrayList<MockMessage>();
        for (int i = low; i <= high; ++i) {
            Message m = this.mailboxFolder.getByMsgNum(i);
            messages.add(new MockMessage(m, (Folder)this));
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public synchronized Message[] getMessagesByUID(long start, long end) throws MessagingException {
        this.checkExists();
        this.checkOpened();
        return this.wrap(this.mailboxFolder.getByIds(start, end));
    }

    public synchronized Message[] getMessagesByUID(long[] uids) throws MessagingException {
        this.checkExists();
        this.checkOpened();
        return this.wrap(this.mailboxFolder.getByIds(uids));
    }

    public synchronized Message[] getMessagesByUIDChangedSince(long start, long end, long modseq) throws MessagingException {
        throw new MessagingException("CONDSTORE not supported");
    }

    public synchronized String getName() {
        return this.mailboxFolder.getName();
    }

    public int getNewMessageCount() throws MessagingException {
        this.checkExists();
        return this.mailboxFolder.getByFlags(new Flags(Flags.Flag.RECENT), true).length;
    }

    public Folder getParent() throws MessagingException {
        this.checkExists();
        if (this.mailboxFolder.getParent() == null) {
            throw new MessagingException("no parent, is already default root");
        }
        return new IMAPMockFolder(this.store, this.mailboxFolder.getParent());
    }

    public Flags getPermanentFlags() {
        return null;
    }

    public char getSeparator() throws MessagingException {
        return '/';
    }

    public int getType() throws MessagingException {
        return this.mailboxFolder.isRoot() ? 2 : 3;
    }

    public synchronized long getUID(Message message) throws MessagingException {
        return this.mailboxFolder.getUID(message);
    }

    public synchronized long getUIDNext() throws MessagingException {
        return this.mailboxFolder.getUniqueMessageId() + 10L;
    }

    public synchronized long getUIDValidity() throws MessagingException {
        return this.mailboxFolder.getUidValidity();
    }

    public void handleResponse(Response r) {
        throw new RuntimeException("not implemented/should not happen");
    }

    public boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        return this.getNewMessageCount() > 0;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public Folder[] list(String pattern) throws MessagingException {
        this.checkExists();
        List<MailboxFolder> children = this.mailboxFolder.getChildren();
        ArrayList<IMAPMockFolder> ret = new ArrayList<IMAPMockFolder>();
        for (MailboxFolder mf : children) {
            if (!mf.isExists()) continue;
            ret.add(new IMAPMockFolder(this.store, mf));
        }
        this.logger.debug("Folder (" + this.getFullName() + ") list return " + ret);
        return ret.toArray(new Folder[ret.size()]);
    }

    @Override
    public void messageAdded(MailboxFolder mf, MockMessage msg) {
        this.notifyMessageAddedListeners(new Message[]{msg});
    }

    @Override
    public void messageChanged(MailboxFolder mf, MockMessage msg, boolean headerChanged, boolean flagsChanged) {
        this.notifyMessageChangedListeners(1, (Message)msg);
    }

    @Override
    public void messageExpunged(MailboxFolder mf, MockMessage msg, boolean removed) {
    }

    public void open(int mode) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        this.opened = true;
        this.openMode = mode;
        this.logger.debug("Open folder " + this.getFullName() + " (" + this.objectId + ")");
        this.notifyConnectionListeners(1);
    }

    public synchronized boolean renameTo(Folder f) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (f.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        this.mailboxFolder.renameFolder(f.getName());
        this.notifyFolderRenamedListeners(f);
        return true;
    }

    @Override
    public void uidInvalidated() {
    }

    private Message[] wrap(Message[] msgs) throws MessagingException {
        Message[] ret = new Message[msgs.length];
        int i = 0;
        for (Message message : msgs) {
            ret[i++] = new MockMessage(message, (Folder)this);
        }
        return ret;
    }

    protected void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder:" + this.getFullName() + " (" + this.objectId + ")");
        }
    }

    protected void checkExists() throws MessagingException {
        if (!this.exists()) {
            throw new FolderNotFoundException((Folder)this, this.getFullName() + " not found");
        }
    }

    protected void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            throw new IllegalStateException("This operation is not allowed on a closed folder: " + this.getFullName() + " (" + this.objectId + ")");
        }
    }

    protected void checkWriteMode() {
        if (this.openMode != 2) {
            throw new IllegalStateException("Folder " + this.getFullName() + " is readonly" + " (" + this.objectId + ")");
        }
    }
}

