/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPStore;
import de.saly.javamail.mock2.IMAPMockFolder;
import de.saly.javamail.mock2.IMAPMockStore;
import de.saly.javamail.mock2.MailboxFolder;
import de.saly.javamail.mock2.MockMailbox;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Folder;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPDefaultMockFolder
extends DefaultFolder {
    private final MockMailbox mailbox;
    private final IMAPMockStore store;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected IMAPDefaultMockFolder(IMAPMockStore store, MockMailbox mailbox) {
        super((IMAPStore)store);
        this.mailbox = mailbox;
        this.store = store;
        this.logger.debug("Created");
    }

    public synchronized boolean create(int type) throws MessagingException {
        return true;
    }

    public synchronized boolean exists() throws MessagingException {
        return true;
    }

    public Folder getFolder(String name) throws MessagingException {
        this.logger.debug("getFolder(" + name + ") on " + this.getFullName());
        if ("inbox".equalsIgnoreCase(name)) {
            return new IMAPMockFolder(this.store, this.mailbox.getInbox());
        }
        return new IMAPMockFolder(this.store, this.mailbox.getRoot().getOrAddSubFolder(name));
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return 2;
    }

    public Folder[] list(String pattern) throws MessagingException {
        List<MailboxFolder> children = this.mailbox.getRoot().getChildren();
        ArrayList<IMAPMockFolder> ret = new ArrayList<IMAPMockFolder>();
        for (MailboxFolder mf : children) {
            if (!mf.isExists()) continue;
            ret.add(new IMAPMockFolder(this.store, mf));
        }
        this.logger.debug("Folder (Defaultroot) list return " + ret);
        return ret.toArray(new Folder[ret.size()]);
    }

    public synchronized Folder[] listSubscribed(String pattern) throws MessagingException {
        return new Folder[0];
    }
}

