/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import de.saly.javamail.mock2.MockMailbox;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockTransport
extends Transport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public MockTransport(Session session, URLName urlname) {
        super(session, urlname);
        this.logger.warn("Mock Transport in use");
        System.out.println("Mock Transport in use");
    }

    public void connect(String host, int port, String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        this.setConnected(true);
        this.notifyConnectionListeners(1);
    }

    public void sendMessage(Message msg, Address[] addresses) throws MessagingException {
        for (Address a : addresses) {
            MockMailbox mailbox = MockMailbox.get(a);
            if (mailbox.getInbox().isSimulateError()) {
                this.notifyTransportListeners(2, new Address[0], addresses, new Address[0], msg);
                throw new MessagingException("Simulated error sending message to " + a);
            }
            mailbox.getInbox().add(new MimeMessage((MimeMessage)msg));
            this.notifyTransportListeners(1, addresses, new Address[0], new Address[0], msg);
        }
    }
}

