/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import de.saly.javamail.mock2.MailboxFolder;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MockMailbox {
    private static final Map<Address, MockMailbox> mailboxes = new HashMap<Address, MockMailbox>();
    private final Address address;
    private final MailboxFolder inbox;
    private final MailboxFolder root = new MailboxFolder("", this, true);

    public static synchronized MockMailbox get(Address a) {
        MockMailbox mb = mailboxes.get(a);
        if (mb == null) {
            mb = new MockMailbox(a);
            mailboxes.put(a, mb);
        }
        return mb;
    }

    public static MockMailbox get(String address) throws AddressException {
        return MockMailbox.get((Address)new InternetAddress(address));
    }

    public static void resetAll() {
        mailboxes.clear();
    }

    private MockMailbox(Address address) {
        this.address = address;
        this.inbox = this.root.addSpecialSubFolder("INBOX");
    }

    private MockMailbox(String address) throws AddressException {
        this((Address)new InternetAddress(address));
    }

    public Address getAddress() {
        return this.address;
    }

    public MailboxFolder getInbox() {
        return this.inbox;
    }

    public MailboxFolder getRoot() {
        return this.root;
    }
}

