/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import com.sun.mail.imap.IMAPStore;
import de.saly.javamail.mock2.IMAPDefaultMockFolder;
import de.saly.javamail.mock2.IMAPMockFolder;
import de.saly.javamail.mock2.MockMailbox;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Quota;
import javax.mail.Session;
import javax.mail.URLName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPMockStore
extends IMAPStore {
    private boolean connected;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MockMailbox mailbox;
    private final UUID objectId = UUID.randomUUID();

    public IMAPMockStore(Session session, URLName urlname) {
        this(session, urlname, "imap", false);
    }

    public IMAPMockStore(Session session, URLName url, String name, boolean isSSL) {
        super(session, url, name, isSSL);
        this.logger.warn("IMAP Mock Store in use");
        System.out.println("IMAP Mock Store in use");
        this.logger.debug("Created " + this.objectId);
    }

    protected void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }

    public synchronized void close() throws MessagingException {
        this.connected = false;
        this.notifyConnectionListeners(3);
        this.logger.debug("Closed " + this.objectId);
    }

    public void connect() throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(this.url.getHost(), this.url.getPort(), this.url.getUsername(), this.url.getPassword());
    }

    public void connect(String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(this.url.getHost(), this.url.getPort(), user, password);
    }

    public void connect(String host, String user, String password) throws MessagingException {
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        super.connect(host, this.url.getPort(), user, password);
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new IMAPDefaultMockFolder(this, this.mailbox);
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        this.logger.debug("getFolder(" + name + ")");
        if ("inbox".equalsIgnoreCase(name)) {
            return new IMAPMockFolder(this, this.mailbox.getInbox());
        }
        return new IMAPMockFolder(this, this.mailbox.getRoot().getOrAddSubFolder(name));
    }

    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return this.getFolder(url.getFile());
    }

    public Folder[] getPersonalNamespaces() throws MessagingException {
        return new Folder[]{this.getDefaultFolder()};
    }

    public synchronized Quota[] getQuota(String root) throws MessagingException {
        throw new MessagingException("QUOTA not supported");
    }

    Session getSession() {
        return this.session;
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        return new Folder[0];
    }

    public Folder[] getUserNamespaces(String user) {
        return new Folder[0];
    }

    public synchronized boolean hasCapability(String capability) throws MessagingException {
        return capability != null && (capability.toLowerCase().startsWith("IMAP4") || capability.toLowerCase().startsWith("IDLE") || capability.toLowerCase().startsWith("ID"));
    }

    public synchronized Map<String, String> id(Map<String, String> clientParams) throws MessagingException {
        this.checkConnected();
        HashMap<String, String> id = new HashMap<String, String>();
        id.put("name", "JavaMail Mock2");
        id.put("vendor", "Hendrik Saly");
        id.put("support-url", "https://github.com/salyh/javamail-mock2/issues");
        return Collections.unmodifiableMap(id);
    }

    public void idle() throws MessagingException {
        this.checkConnected();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        this.logger.debug("Connect to " + user + " (" + this.objectId + ")");
        this.mailbox = MockMailbox.get(user);
        if (this.mailbox.getInbox().isSimulateError()) {
            throw new MessagingException("Simulated error connecting to mailbox of " + user);
        }
        this.connected = true;
        return true;
    }

    public synchronized void setQuota(Quota quota) throws MessagingException {
        throw new MessagingException("QUOTA not supported");
    }
}

