/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.tssl.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class SecurityUtil {
    private static final ESLogger log = Loggers.getLogger(SecurityUtil.class);
    private static final String[] PREFERRED_SSL_CIPHERS = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"};
    private static final String[] PREFERRED_SSL_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    public static String[] ENABLED_SSL_PROTOCOLS = null;
    public static String[] ENABLED_SSL_CIPHERS = null;
    public static boolean UNLIMITED_STRENGTH_SUPPORTED;

    private SecurityUtil() {
    }

    public static File getAbsoluteFilePathFromClassPath(String fileNameFromClasspath) {
        File jaasConfigFile = null;
        URL jaasConfigURL = SecurityUtil.class.getClassLoader().getResource(fileNameFromClasspath);
        if (jaasConfigURL != null) {
            try {
                jaasConfigFile = new File(URLDecoder.decode(jaasConfigURL.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            if (jaasConfigFile.exists() && jaasConfigFile.canRead()) {
                return jaasConfigFile;
            }
            log.error("Cannot read from {}, maybe the file does not exists? ", new Object[]{jaasConfigFile.getAbsolutePath()});
        } else {
            log.error("Failed to load " + fileNameFromClasspath, new Object[0]);
        }
        return null;
    }

    public static boolean setSystemPropertyToAbsoluteFilePathFromClassPath(String property, String fileNameFromClasspath) {
        if (System.getProperty(property) == null) {
            File jaasConfigFile = null;
            URL jaasConfigURL = SecurityUtil.class.getClassLoader().getResource(fileNameFromClasspath);
            if (jaasConfigURL != null) {
                try {
                    jaasConfigFile = new File(URLDecoder.decode(jaasConfigURL.getFile(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
                if (jaasConfigFile.exists() && jaasConfigFile.canRead()) {
                    System.setProperty(property, jaasConfigFile.getAbsolutePath());
                    log.debug("Load " + fileNameFromClasspath + " from {} ", new Object[]{jaasConfigFile.getAbsolutePath()});
                    return true;
                }
                log.error("Cannot read from {}, maybe the file does not exists? ", new Object[]{jaasConfigFile.getAbsolutePath()});
            } else {
                log.error("Failed to load " + fileNameFromClasspath, new Object[0]);
            }
        } else {
            log.warn("Property " + property + " already set to " + System.getProperty(property), new Object[0]);
        }
        return false;
    }

    public static boolean setSystemPropertyToAbsoluteFile(String property, String fileName) {
        if (System.getProperty(property) == null) {
            if (fileName == null) {
                log.error("Cannot set property " + property + " because filename is null", new Object[0]);
                return false;
            }
            File jaasConfigFile = new File(fileName).getAbsoluteFile();
            if (jaasConfigFile.exists() && jaasConfigFile.canRead()) {
                System.setProperty(property, jaasConfigFile.getAbsolutePath());
                log.debug("Load " + fileName + " from {} ", new Object[]{jaasConfigFile.getAbsolutePath()});
                return true;
            }
            log.error("Cannot read from {}, maybe the file does not exists? ", new Object[]{jaasConfigFile.getAbsolutePath()});
        } else {
            log.warn("Property " + property + " already set to " + System.getProperty(property), new Object[0]);
        }
        return false;
    }

    static {
        try {
            int aesMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (aesMaxKeyLength < 256) {
                log.warn("AES 256 not supported, max key length for AES is " + aesMaxKeyLength + ". To enable AES 256 install 'Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files'", new Object[0]);
            } else {
                UNLIMITED_STRENGTH_SUPPORTED = true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error("AES encryption not supported. " + e, new Object[0]);
        }
        try {
            SSLContext serverContext = SSLContext.getInstance("TLS");
            serverContext.init(null, null, null);
            SSLEngine engine = serverContext.createSSLEngine();
            ArrayList<String> supportedCipherSuites = new ArrayList<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            ArrayList<String> supportedProtocols = new ArrayList<String>(Arrays.asList(engine.getSupportedProtocols()));
            List<String> preferredCipherSuites = Arrays.asList(PREFERRED_SSL_CIPHERS);
            List<String> preferredProtocols = Arrays.asList(PREFERRED_SSL_PROTOCOLS);
            supportedCipherSuites.retainAll(preferredCipherSuites);
            supportedProtocols.retainAll(preferredProtocols);
            if (supportedCipherSuites.isEmpty()) {
                log.error("No usable SSL/TLS cipher suites found", new Object[0]);
            } else {
                ENABLED_SSL_CIPHERS = supportedCipherSuites.toArray(new String[supportedCipherSuites.size()]);
            }
            if (supportedProtocols.isEmpty()) {
                log.error("No usable SSL/TLS protocols found", new Object[0]);
            } else {
                ENABLED_SSL_PROTOCOLS = supportedProtocols.toArray(new String[supportedProtocols.size()]);
            }
            log.debug("Usable SSL/TLS protocols: {}", new Object[]{supportedProtocols});
            log.debug("Usable SSL/TLS cipher suites: {}", new Object[]{supportedCipherSuites});
        }
        catch (Exception e) {
            log.error("Error while evaluating supported crypto", (Throwable)e, new Object[0]);
        }
    }
}

