/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.tssl.rest;

import de.saly.es.example.tssl.util.SecurityUtil;
import java.io.IOException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class TSslRestAction
extends BaseRestHandler {
    @Inject
    public TSslRestAction(Settings settings, Client client, RestController controller) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_tssl/state", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_tssl/state", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        if (request.param("cat") != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("enabled protocols\n");
            for (String protocol : SecurityUtil.ENABLED_SSL_PROTOCOLS) {
                sb.append(protocol + "\n");
            }
            sb.append("\nenabled ciphers\n");
            for (String cipher : SecurityUtil.ENABLED_SSL_CIPHERS) {
                sb.append(cipher + "\n");
            }
            sb.append("\nunlimited strength policy installed\n");
            sb.append(SecurityUtil.UNLIMITED_STRENGTH_SUPPORTED);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "text/plain", sb.toString()));
            return;
        }
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            builder.field("enabled_protocols", SecurityUtil.ENABLED_SSL_PROTOCOLS);
            builder.field("enabled_chipers", SecurityUtil.ENABLED_SSL_CIPHERS);
            builder.field("unlimited_strength_policy_installed", SecurityUtil.UNLIMITED_STRENGTH_SUPPORTED);
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        }
        catch (IOException e) {
            try {
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Throwable)e));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send a failure response.", (Throwable)e1, new Object[0]);
            }
        }
    }
}

