/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.tssl.plugin;

import de.saly.es.example.tssl.netty.SSLNettyTransport;
import de.saly.es.example.tssl.netty.UnexpectedSecurityException;
import de.saly.es.example.tssl.rest.TSslRestAction;
import org.elasticsearch.common.lang3.StringUtils;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.transport.TransportModule;

public class TSslPlugin
extends AbstractPlugin {
    private final Settings settings;

    public TSslPlugin(Settings settings) {
        this.settings = settings;
    }

    public String name() {
        return "elasticsearch-sample-plugin-tssl";
    }

    public String description() {
        return "Elasticsearch example plugin which implements and enforces transport layer SSL/TLS encryption";
    }

    public void onModule(TransportModule transportModule) {
        transportModule.setTransport(SSLNettyTransport.class, this.name());
    }

    public void onModule(RestModule restModule) {
        restModule.addRestAction(TSslRestAction.class);
    }

    public Settings additionalSettings() {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        if (this.settings.getAsBoolean("security.ssl.transport.node.enabled", Boolean.valueOf(false)).booleanValue()) {
            String keystoreFilePath = this.settings.get("security.ssl.transport.node.keystore.path", System.getProperty("javax.net.ssl.keyStore", null));
            String truststoreFilePath = this.settings.get("security.ssl.transport.node.truststore.path", System.getProperty("javax.net.ssl.trustStore", null));
            if (StringUtils.isBlank((CharSequence)keystoreFilePath) || StringUtils.isBlank((CharSequence)truststoreFilePath)) {
                throw new UnexpectedSecurityException("security.ssl.transport.node.keystore.path and security.ssl.transport.node.truststore.path must be set if transport ssl is reqested.");
            }
        }
        return settingsBuilder.build();
    }
}

