/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.tssl.netty;

import de.saly.es.example.tssl.netty.SecureMessageChannelHandler;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty.NettyTransport;

public abstract class SecureNettyTransport
extends NettyTransport {
    protected SecureNettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, Version version) {
        super(settings, threadPool, networkService, bigArrays, version);
    }

    protected static class SecureClientChannelPipelineFactory
    extends NettyTransport.ClientChannelPipelineFactory {
        protected final NettyTransport nettyTransport;
        protected static final ESLogger log = Loggers.getLogger(SecureClientChannelPipelineFactory.class);

        public SecureClientChannelPipelineFactory(NettyTransport nettyTransport) {
            super(nettyTransport);
            this.nettyTransport = nettyTransport;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            pipeline.replace("dispatcher", "dispatcher", (ChannelHandler)new SecureMessageChannelHandler(this.nettyTransport, log));
            return pipeline;
        }
    }

    protected static class SecureServerChannelPipelineFactory
    extends NettyTransport.ServerChannelPipelineFactory {
        protected final NettyTransport nettyTransport;
        protected static final ESLogger log = Loggers.getLogger(SecureServerChannelPipelineFactory.class);

        public SecureServerChannelPipelineFactory(NettyTransport nettyTransport, String name, Settings settings) {
            super(nettyTransport, name, settings);
            this.nettyTransport = nettyTransport;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            pipeline.replace("dispatcher", "dispatcher", (ChannelHandler)new SecureMessageChannelHandler(this.nettyTransport, log));
            return pipeline;
        }
    }
}

