/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.tssl.netty;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.handler.ssl.SslHandler;
import org.elasticsearch.transport.netty.MessageChannelHandler;
import org.elasticsearch.transport.netty.NettyTransport;

public class SecureMessageChannelHandler
extends MessageChannelHandler {
    public SecureMessageChannelHandler(NettyTransport transport, ESLogger logger) {
        super(transport, logger, "default");
    }

    public void channelConnected(final ChannelHandlerContext ctx, final ChannelStateEvent e) {
        final SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
        ChannelFuture handshakeFuture = sslHandler.handshake();
        handshakeFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (SecureMessageChannelHandler.this.logger.isTraceEnabled()) {
                    SecureMessageChannelHandler.this.logger.trace("Node to Node encryption cipher is {}/{}", new Object[]{sslHandler.getEngine().getSession().getProtocol(), sslHandler.getEngine().getSession().getCipherSuite()});
                }
                ctx.sendUpstream((ChannelEvent)e);
            }
        });
    }
}

