/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.tssl.netty;

import de.saly.es.example.tssl.netty.SecureNettyTransport;
import de.saly.es.example.tssl.util.SecurityUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lang3.StringUtils;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.SimpleChannelHandler;
import org.elasticsearch.common.netty.handler.ssl.SslHandler;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty.NettyTransport;

public class SSLNettyTransport
extends SecureNettyTransport {
    private static final int SECURITY_SSL_TRANSPORT_NODE_SESSION_CACHE_SIZE_DEFAULT = 1000;
    private static final int SECURITY_SSL_TRANSPORT_NODE_SESSION_TIMEOUT_DEFAULT = 86400;
    private final Map<String, SSLContext> contextCache = ConcurrentCollections.newConcurrentMap();

    @Inject
    public SSLNettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, Version version) {
        super(settings, threadPool, networkService, bigArrays, version);
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        this.logger.info("Node client configured for SSL", new Object[0]);
        return new SSLClientChannelPipelineFactory(this, this.settings);
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings settings) {
        this.logger.info("Node server configured for SSL", new Object[0]);
        return new SSLServerChannelPipelineFactory(this, name, settings, this.settings);
    }

    private SSLContext createSSLContext(String keystoreType, String keystoreFilePath, String keystorePassword, String truststoreType, String truststoreFilePath, String truststorePassword, int sslSessionCacheSize, int sslSessionTimeout) throws KeyManagementException, KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException {
        if (StringUtils.isBlank((CharSequence)keystoreFilePath) || StringUtils.isBlank((CharSequence)truststoreFilePath)) {
            this.logger.error("security.ssl.transport.node.keystore.path and security.ssl.transport.node.truststore.path must be set if transport ssl is reqested.", new Object[0]);
            throw new IOException("security.ssl.transport.node.keystore.path and security.ssl.transport.node.truststore.path must be set if transport ssl is reqested.");
        }
        String contextKey = keystoreFilePath + truststoreFilePath;
        if (this.contextCache.containsKey(contextKey)) {
            return this.contextCache.get(contextKey);
        }
        KeyStore ks = KeyStore.getInstance(keystoreType);
        ks.load(new FileInputStream(new File(keystoreFilePath)), keystorePassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keystorePassword.toCharArray());
        KeyStore ts = KeyStore.getInstance(truststoreType);
        ts.load(new FileInputStream(new File(truststoreFilePath)), truststorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        sslContext.getServerSessionContext().setSessionCacheSize(sslSessionCacheSize);
        sslContext.getServerSessionContext().setSessionTimeout(sslSessionTimeout);
        this.contextCache.put(contextKey, sslContext);
        return sslContext;
    }

    protected class SSLClientChannelPipelineFactory
    extends SecureNettyTransport.SecureClientChannelPipelineFactory {
        private final String keystoreType;
        private final String keystoreFilePath;
        private final String keystorePassword;
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final String truststoreType;
        private final String truststoreFilePath;
        private final String truststorePassword;
        private final int sslSessionCacheSize;
        private final int sslSessionTimeout;

        public SSLClientChannelPipelineFactory(NettyTransport nettyTransport, Settings essettings) {
            super(nettyTransport);
            this.keystoreType = essettings.get("security.ssl.transport.node.keystore.type", System.getProperty("javax.net.ssl.keyStoreType", "JKS"));
            this.keystoreFilePath = essettings.get("security.ssl.transport.node.keystore.path", System.getProperty("javax.net.ssl.keyStore", null));
            this.keystorePassword = essettings.get("security.ssl.transport.node.keystore.password", System.getProperty("javax.net.ssl.keyStorePassword", "changeit"));
            this.truststoreType = essettings.get("security.ssl.transport.node.truststore.type", System.getProperty("javax.net.ssl.trustStoreType", "JKS"));
            this.truststoreFilePath = essettings.get("security.ssl.transport.node.truststore.path", System.getProperty("javax.net.ssl.trustStore", null));
            this.truststorePassword = essettings.get("security.ssl.transport.node.truststore.password", System.getProperty("javax.net.ssl.trustStorePassword", "changeit"));
            this.sslSessionCacheSize = essettings.getAsInt("security.ssl.transport.node.truststore.type", Integer.valueOf(1000));
            this.sslSessionTimeout = essettings.getAsInt("security.ssl.transport.node.truststore.type", Integer.valueOf(86400));
            this.hostnameVerificationEnabled = essettings.getAsBoolean("security.ssl.transport.node.hostname_verification.enabled", Boolean.valueOf(true));
            this.hostnameVerificationResovleHostName = essettings.getAsBoolean("security.ssl.transport.node.hostname_verification.resolve_host_name", Boolean.valueOf(true));
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            SSLContext clientContext = SSLNettyTransport.this.createSSLContext(this.keystoreType, this.keystoreFilePath, this.keystorePassword, this.truststoreType, this.truststoreFilePath, this.truststorePassword, this.sslSessionCacheSize, this.sslSessionTimeout);
            pipeline.addFirst("client_ssl_handler", (ChannelHandler)new ClientSslHandler(clientContext, this.hostnameVerificationEnabled, this.hostnameVerificationResovleHostName));
            return pipeline;
        }
    }

    protected static class ClientSslHandler
    extends SimpleChannelHandler {
        private final SSLContext serverContext;
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;

        private ClientSslHandler(SSLContext serverContext, boolean hostnameVerificationEnabled, boolean hostnameVerificationResovleHostName) {
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.hostnameVerificationResovleHostName = hostnameVerificationResovleHostName;
            this.serverContext = serverContext;
        }

        public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent event) {
            SSLEngine engine = null;
            SSLParameters sslParams = new SSLParameters();
            sslParams.setCipherSuites(SecurityUtil.ENABLED_SSL_CIPHERS);
            sslParams.setProtocols(SecurityUtil.ENABLED_SSL_PROTOCOLS);
            if (this.hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)event.getValue();
                String hostname = null;
                hostname = this.hostnameVerificationResovleHostName ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                engine = this.serverContext.createSSLEngine(hostname, inetSocketAddress.getPort());
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            } else {
                engine = this.serverContext.createSSLEngine();
            }
            engine.setSSLParameters(sslParams);
            engine.setUseClientMode(true);
            SslHandler sslHandler = new SslHandler(engine);
            sslHandler.setEnableRenegotiation(true);
            ctx.getPipeline().replace((ChannelHandler)this, "ssl_client", (ChannelHandler)sslHandler);
            ctx.sendDownstream((ChannelEvent)event);
        }
    }

    protected class SSLServerChannelPipelineFactory
    extends SecureNettyTransport.SecureServerChannelPipelineFactory {
        private final String keystoreType;
        private final String keystoreFilePath;
        private final String keystorePassword;
        private final boolean needClientAuth;
        private final String truststoreType;
        private final String truststoreFilePath;
        private final String truststorePassword;
        private final int sslSessionCacheSize;
        private final int sslSessionTimeout;

        public SSLServerChannelPipelineFactory(NettyTransport nettyTransport, String name, Settings sslsettings, Settings essettings) {
            super(nettyTransport, name, sslsettings);
            this.keystoreType = essettings.get("security.ssl.transport.node.keystore.type", System.getProperty("javax.net.ssl.keyStoreType", "JKS"));
            this.keystoreFilePath = essettings.get("security.ssl.transport.node.keystore.path", System.getProperty("javax.net.ssl.keyStore", null));
            this.keystorePassword = essettings.get("security.ssl.transport.node.keystore.password", System.getProperty("javax.net.ssl.keyStorePassword", "changeit"));
            this.truststoreType = essettings.get("security.ssl.transport.node.truststore.type", System.getProperty("javax.net.ssl.trustStoreType", "JKS"));
            this.truststoreFilePath = essettings.get("security.ssl.transport.node.truststore.path", System.getProperty("javax.net.ssl.trustStore", null));
            this.truststorePassword = essettings.get("security.ssl.transport.node.truststore.password", System.getProperty("javax.net.ssl.trustStorePassword", "changeit"));
            this.sslSessionCacheSize = essettings.getAsInt("security.ssl.transport.node.truststore.type", Integer.valueOf(1000));
            this.sslSessionTimeout = essettings.getAsInt("security.ssl.transport.node.truststore.type", Integer.valueOf(86400));
            this.needClientAuth = essettings.getAsBoolean("security.ssl.transport.node.need_clientauth", Boolean.valueOf(true));
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            SSLContext serverContext = SSLNettyTransport.this.createSSLContext(this.keystoreType, this.keystoreFilePath, this.keystorePassword, this.truststoreType, this.truststoreFilePath, this.truststorePassword, this.sslSessionCacheSize, this.sslSessionTimeout);
            SSLEngine engine = serverContext.createSSLEngine();
            SSLParameters sslParams = new SSLParameters();
            sslParams.setCipherSuites(SecurityUtil.ENABLED_SSL_CIPHERS);
            sslParams.setProtocols(SecurityUtil.ENABLED_SSL_PROTOCOLS);
            sslParams.setNeedClientAuth(this.needClientAuth);
            engine.setSSLParameters(sslParams);
            engine.setUseClientMode(false);
            SslHandler sslHandler = new SslHandler(engine);
            sslHandler.setEnableRenegotiation(true);
            pipeline.addFirst("ssl_server", (ChannelHandler)sslHandler);
            return pipeline;
        }
    }
}

