/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.audit.service;

import de.saly.es.example.audit.action.flush.TransportFlushAction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.netty.util.internal.ConcurrentHashMap;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.indexing.IndexingOperationListener;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;

public class AuditService
extends AbstractLifecycleComponent<AuditService> {
    public static final String SETTING_AUDIT_INDEX_NAME = "audit.index_name";
    public static final String SETTING_AUDIT_CAPTURE_SETTINGS_CHANGES = "audit.capture_settings_changes";
    public static final String DEFAULT_AUDIT_INDEX_NAME = "audit";
    public static final String AUDIT_INDEX_INDEXING_TYPE = "indexevents";
    private final String auditIndexName;
    private final boolean captureSettingsChanges;
    private final IndicesService indicesService;
    private final Client client;
    private final ClusterService clusterService;
    private volatile boolean isMaster = false;
    private final BulkProcessor bulk;
    private final AtomicInteger pendingBulkItemCount = new AtomicInteger();
    private Thread poller;
    private final IndicesLifecycle.Listener auditIndicesLsListener = new IndicesLifecycle.Listener(){
        private final ConcurrentHashMap<ShardId, AuditIndexOpListener> listeners = new ConcurrentHashMap();

        public void afterIndexCreated(IndexService indexService) {
            if (AuditService.this.isMaster && !indexService.index().name().equals(AuditService.this.auditIndexName)) {
                AuditService.this.recordIndexCreate(indexService);
            }
        }

        public void afterIndexDeleted(Index index, Settings indexSettings) {
            if (AuditService.this.isMaster && !index.name().equals(AuditService.this.auditIndexName)) {
                AuditService.this.recordIndexDelete(index);
            }
        }

        public void afterIndexShardStarted(IndexShard indexShard) {
            if (indexShard.routingEntry().primary() && !indexShard.indexService().index().name().equals(AuditService.this.auditIndexName)) {
                AuditIndexOpListener auditListener = new AuditIndexOpListener(indexShard);
                if (AuditService.this.captureSettingsChanges) {
                    indexShard.indexService().settingsService().addListener((IndexSettingsService.Listener)auditListener);
                }
                indexShard.indexingService().addListener((IndexingOperationListener)auditListener);
                this.listeners.put((Object)indexShard.shardId(), (Object)auditListener);
                AuditService.this.logger.info("Listener for shard {} added", new Object[]{indexShard.shardId()});
            }
        }

        public void beforeIndexShardClosed(ShardId shardId, IndexShard indexShard, Settings indexSettings) {
            AuditIndexOpListener listener = (AuditIndexOpListener)((Object)this.listeners.remove((Object)shardId));
            if (listener != null) {
                indexShard.indexingService().removeListener((IndexingOperationListener)listener);
                AuditService.this.logger.info("Listener for shard {} removed", new Object[]{shardId});
            }
        }
    };
    private final LinkedBlockingQueue<IndexRequest> queue = new LinkedBlockingQueue();

    @Inject
    public AuditService(Settings settings, IndicesService indicesService, final Client client, ClusterService clusterService, TransportFlushAction tfa) {
        super(settings);
        this.auditIndexName = settings.get(SETTING_AUDIT_INDEX_NAME, DEFAULT_AUDIT_INDEX_NAME);
        this.captureSettingsChanges = settings.getAsBoolean(SETTING_AUDIT_CAPTURE_SETTINGS_CHANGES, Boolean.valueOf(false));
        this.indicesService = indicesService;
        this.client = client;
        this.clusterService = clusterService;
        tfa.setAuditService(this);
        this.bulk = BulkProcessor.builder((Client)client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                AuditService.this.logger.error("Bulk error", failure, new Object[0]);
                AuditService.this.pendingBulkItemCount.addAndGet(-request.numberOfActions());
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                AuditService.this.pendingBulkItemCount.addAndGet(-response.getItems().length);
            }
        }).setBulkActions(100).setConcurrentRequests(0).build();
        this.clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute((ActionListener)new ActionListener<ClusterHealthResponse>(){

                    public void onResponse(ClusterHealthResponse response) {
                        if (response.getStatus() == ClusterHealthStatus.RED) {
                            AuditService.this.logger.error("The cluster is not available. The status is RED.", new Object[0]);
                        } else {
                            AuditService.this.logger.info("cluster ok, will check index", new Object[0]);
                            AuditService.this.checkAuditIndex();
                        }
                    }

                    public void onFailure(Throwable e) {
                        AuditService.this.logger.error("The cluster is not available.", e, new Object[0]);
                    }
                });
            }
        });
    }

    private void createAuditIndex() {
        this.logger.info("will create audit index", new Object[0]);
        Settings auditIndexSettings = ImmutableSettings.builder().put("index.number_of_shards", 3).put("index.number_of_replicas", 1).build();
        XContentBuilder auditIndexEventsTypeMapping = Change.getMapping();
        this.client.admin().indices().prepareCreate(this.auditIndexName).addMapping(AUDIT_INDEX_INDEXING_TYPE, auditIndexEventsTypeMapping).setSettings(auditIndexSettings).execute((ActionListener)new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse response) {
                if (!response.isAcknowledged()) {
                    AuditService.this.logger.error("Failed to create {}.", new Object[]{AuditService.this.auditIndexName});
                    throw new ElasticsearchException("Failed to create index " + AuditService.this.auditIndexName);
                }
            }

            public void onFailure(Throwable e) {
                AuditService.this.logger.error("Failed to create {}", e, new Object[]{AuditService.this.auditIndexName});
            }
        });
    }

    private void checkAuditIndex() {
        this.client.admin().indices().prepareExists(new String[]{this.auditIndexName}).execute((ActionListener)new ActionListener<IndicesExistsResponse>(){

            public void onResponse(IndicesExistsResponse response) {
                if (response.isExists()) {
                    if (AuditService.this.logger.isDebugEnabled()) {
                        AuditService.this.logger.debug("{} index exists already.", new Object[]{AuditService.this.auditIndexName});
                    }
                } else {
                    AuditService.this.createAuditIndex();
                }
            }

            public void onFailure(Throwable e) {
                AuditService.this.logger.error("The state of {} index is invalid.", e, new Object[]{AuditService.this.auditIndexName});
            }
        });
    }

    protected void doStart() throws ElasticsearchException {
        this.logger.info("doStart()", new Object[0]);
        this.poller = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IndexRequest req;
                    while ((req = (IndexRequest)AuditService.this.queue.take()) != null) {
                        AuditService.this.bulk.add(req);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                AuditService.this.logger.info("poller thread died", new Object[0]);
            }
        });
        this.poller.setDaemon(true);
        this.poller.setName("poller");
        this.poller.start();
        this.clusterService.add(new ClusterStateListener(){

            public void clusterChanged(ClusterChangedEvent event) {
                if (event.localNodeMaster()) {
                    AuditService.this.isMaster = true;
                } else {
                    AuditService.this.isMaster = false;
                }
            }
        });
        this.indicesService.indicesLifecycle().addListener(this.auditIndicesLsListener);
    }

    protected void doStop() throws ElasticsearchException {
        this.logger.info("doStop()", new Object[0]);
        this.shutdown();
    }

    protected void doClose() throws ElasticsearchException {
        this.logger.info("doClose()", new Object[0]);
        this.shutdown();
    }

    private void shutdown() {
        this.flush();
        this.indicesService.indicesLifecycle().removeListener(this.auditIndicesLsListener);
        try {
            this.bulk.awaitClose(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.queue.add(null);
            try {
                this.poller.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IllegalStateException ise) {
            this.logger.warn("Cannot shutdown poller thread", (Throwable)ise, new Object[0]);
        }
    }

    public int flush() {
        while (this.queue.size() > 0) {
            LockSupport.parkNanos(50000L);
        }
        int count = this.pendingBulkItemCount.get();
        this.bulk.flush();
        while (this.pendingBulkItemCount.get() > 0) {
            LockSupport.parkNanos(50000L);
        }
        this.logger.info("flushing " + count + " ...", new Object[0]);
        return count;
    }

    protected void recordIndexCreate(IndexService indexService) {
        if (indexService == null) {
            return;
        }
        String nodeName = indexService.nodeName();
        String indexName = indexService.index().name();
        Settings indexSettings = indexService.settingsService().getSettings();
        BytesReference settingsAsBytesReference = null;
        try {
            settingsAsBytesReference = indexSettings.toXContent(XContentBuilder.builder((XContent)JsonXContent.jsonXContent), ToXContent.EMPTY_PARAMS).bytes();
        }
        catch (IOException e) {
            this.logger.error("Unable to convert to bytes reference", (Throwable)e, new Object[0]);
        }
        Change change = new Change(nodeName, indexName, null, null, settingsAsBytesReference, -1L, Change.ChangeType.INDEX_CREATE);
        this.storeChange(change);
    }

    protected void recordIndexDelete(Index index) {
        if (index == null) {
            return;
        }
        String indexName = index.name();
        Change change = new Change(null, indexName, null, null, null, -1L, Change.ChangeType.INDEX_DELETE);
        this.storeChange(change);
    }

    protected void recordDataChange(Engine.DeleteByQuery operation, IndexShard indexShard) {
        if (operation == null) {
            return;
        }
        String nodeName = indexShard.nodeName();
        String indexName = indexShard.indexService().index().name();
        Change change = new Change(nodeName, indexName, operation.types(), null, operation.source(), -1L, Change.ChangeType.DATA_DELETE);
        this.storeChange(change);
    }

    protected void recordDataChange(Engine.Create operation, IndexShard indexShard) {
        if (operation == null) {
            return;
        }
        String nodeName = indexShard.nodeName();
        String indexName = indexShard.indexService().index().name();
        Change change = new Change(nodeName, indexName, new String[]{operation.type()}, operation.id(), operation.source(), operation.version(), Change.ChangeType.DATA_CREATE);
        this.storeChange(change);
    }

    protected void recordDataChange(Engine.Delete operation, IndexShard indexShard) {
        if (operation == null) {
            return;
        }
        String nodeName = indexShard.nodeName();
        String indexName = indexShard.indexService().index().name();
        Change change = new Change(nodeName, indexName, new String[]{operation.type()}, operation.id(), null, operation.version(), Change.ChangeType.DATA_DELETE);
        this.storeChange(change);
    }

    protected void recordDataChange(Engine.Index operation, IndexShard indexShard) {
        if (operation == null) {
            return;
        }
        String nodeName = indexShard.nodeName();
        String indexName = indexShard.indexService().index().name();
        Change change = new Change(nodeName, indexName, new String[]{operation.type()}, operation.id(), operation.source(), operation.version(), Change.ChangeType.DATA_CREATE);
        this.storeChange(change);
    }

    protected void recordIndexSettingsChange(Settings settings, IndexShard indexShard) {
        String nodeName = indexShard.nodeName();
        String indexName = indexShard.indexService().index().name();
        BytesReference settingsAsBytesReference = null;
        try {
            settingsAsBytesReference = settings.toXContent(XContentBuilder.builder((XContent)JsonXContent.jsonXContent), ToXContent.EMPTY_PARAMS).bytes();
        }
        catch (IOException e) {
            this.logger.error("Unable to convert to bytes reference", (Throwable)e, new Object[0]);
        }
        Change change = new Change(nodeName, indexName, null, null, settingsAsBytesReference, -1L, Change.ChangeType.INDEX_SETTINGS);
        this.storeChange(change);
    }

    protected void storeChange(Change change) {
        try {
            this.queue.put(new IndexRequest(this.auditIndexName).type(AUDIT_INDEX_INDEXING_TYPE).source(change.event));
            this.pendingBulkItemCount.addAndGet(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class AuditIndexOpListener
    extends IndexingOperationListener
    implements IndexSettingsService.Listener {
        private final IndexShard indexShard;

        public AuditIndexOpListener(IndexShard indexShard) {
            this.indexShard = indexShard;
        }

        public void postIndex(Engine.Index index) {
            AuditService.this.recordDataChange(index, this.indexShard);
        }

        public void postDelete(Engine.Delete delete) {
            AuditService.this.recordDataChange(delete, this.indexShard);
        }

        public void postDeleteByQuery(Engine.DeleteByQuery deleteByQuery) {
            AuditService.this.recordDataChange(deleteByQuery, this.indexShard);
        }

        public void postCreate(Engine.Create create) {
            AuditService.this.recordDataChange(create, this.indexShard);
        }

        public void onRefreshSettings(Settings settings) {
            AuditService.this.recordIndexSettingsChange(settings, this.indexShard);
        }
    }

    protected static class Change {
        private final Map<String, Object> event = new HashMap<String, Object>();

        public Change(String nodeName, String index, String[] type, String id, BytesReference jsonContent, long version, ChangeType changeType) {
            this.event.put("@timestamp", new Date());
            this.event.put("node_name", nodeName);
            this.event.put("index", index);
            this.event.put("type", type == null ? null : Arrays.asList(type));
            this.event.put("id", id);
            try {
                this.event.put("content", jsonContent == null ? null : XContentHelper.convertToJson((BytesReference)jsonContent, (boolean)false));
            }
            catch (IOException e) {
                this.event.put("content", e.toString());
            }
            this.event.put("version", version);
            this.event.put("change_type", changeType.toString());
        }

        public static XContentBuilder getMapping() {
            try {
                return XContentBuilder.builder((XContent)JsonXContent.jsonXContent).startObject().startObject(AuditService.AUDIT_INDEX_INDEXING_TYPE).startObject("properties").startObject("@timestamp").field("type", "date").field("format", "dateOptionalTime").endObject().startObject("node_name").field("type", "string").field("index", "not_analyzed").endObject().startObject("index").field("type", "string").field("index", "not_analyzed").endObject().startObject("type").field("type", "string").field("index", "not_analyzed").endObject().startObject("id").field("type", "string").field("index", "not_analyzed").endObject().startObject("content").field("type", "string").endObject().startObject("version").field("type", "long").endObject().startObject("change_type").field("type", "string").field("index", "not_analyzed").endObject().endObject().endObject().endObject();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "Change [event=" + this.event + "]";
        }

        public static enum ChangeType {
            DATA_CREATE,
            INDEX_CREATE,
            DATA_DELETE,
            INDEX_DELETE,
            INDEX_SETTINGS;

        }
    }
}

