/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.audit.plugin;

import de.saly.es.example.audit.plugin.AuditModule;
import de.saly.es.example.audit.service.AuditService;
import java.util.Collection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.AbstractPlugin;

public class AuditPlugin
extends AbstractPlugin {
    private final Settings settings;
    private final boolean clientMode;

    public AuditPlugin(Settings settings) {
        this.settings = settings;
        this.clientMode = AuditPlugin.clientMode(settings);
    }

    public static boolean clientMode(Settings settings) {
        return !"node".equals(settings.get("client.type"));
    }

    public String name() {
        return "AuditPlugin";
    }

    public String description() {
        return "This is the description for the AuditPlugin";
    }

    public Collection<Class<? extends Module>> modules() {
        return ImmutableList.of(AuditModule.class);
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        if (!this.clientMode) {
            return ImmutableList.of(AuditService.class);
        }
        return ImmutableList.of();
    }
}

