/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.audit.action.flush;

import de.saly.es.example.audit.action.flush.FlushRequest;
import de.saly.es.example.audit.action.flush.FlushResponse;
import de.saly.es.example.audit.action.flush.NodeFlushRequest;
import de.saly.es.example.audit.action.flush.NodeFlushResponse;
import de.saly.es.example.audit.service.AuditService;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportFlushAction
extends TransportNodesOperationAction<FlushRequest, FlushResponse, NodeFlushRequest, NodeFlushResponse> {
    private AuditService auditService;

    @Inject
    public TransportFlushAction(Settings settings, String actionName, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, actionName, clusterName, threadPool, clusterService, transportService, actionFilters);
        this.transportService.registerHandler("cluster:admin/auditplugin/flush", (TransportRequestHandler)new FlushRequestHandler());
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    protected String executor() {
        return "management";
    }

    protected FlushRequest newRequest() {
        return new FlushRequest();
    }

    protected FlushResponse newResponse(FlushRequest request, AtomicReferenceArray nodesResponses) {
        ArrayList nodes = Lists.newArrayList();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object resp = nodesResponses.get(i);
            if (!(resp instanceof NodeFlushResponse)) continue;
            nodes.add((NodeFlushResponse)((Object)resp));
        }
        return new FlushResponse(this.clusterName, nodes.toArray(new NodeFlushResponse[nodes.size()]));
    }

    protected NodeFlushRequest newNodeRequest() {
        return new NodeFlushRequest();
    }

    protected NodeFlushRequest newNodeRequest(String nodeId, FlushRequest request) {
        return new NodeFlushRequest(request, nodeId);
    }

    protected NodeFlushResponse newNodeResponse() {
        return new NodeFlushResponse();
    }

    protected NodeFlushResponse nodeOperation(NodeFlushRequest request) throws ElasticsearchException {
        int count = this.flush();
        return new NodeFlushResponse(this.clusterService.localNode(), count);
    }

    private int flush() {
        return this.auditService.flush();
    }

    protected boolean accumulateExceptions() {
        return false;
    }

    private class FlushRequestHandler
    extends BaseTransportRequestHandler<FlushRequest> {
        private FlushRequestHandler() {
        }

        public FlushRequest newInstance() {
            return new FlushRequest();
        }

        public String executor() {
            return "management";
        }

        public final void messageReceived(final FlushRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportFlushAction.this.execute((ActionRequest)request, (ActionListener)new ActionListener<FlushResponse>(){

                public void onResponse(FlushResponse response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportFlushAction.this.logger.warn("Failed to send error response for action [{}] and request [{}]", new Object[]{TransportFlushAction.this.actionName, request, e1});
                    }
                }
            });
        }
    }
}

