/*
 * Decompiled with CFR 0.152.
 */
package de.saly.es.example.audit.action.flush;

import de.saly.es.example.audit.action.flush.NodeFlushResponse;
import java.io.IOException;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FlushResponse
extends NodesOperationResponse<NodeFlushResponse>
implements ToXContent {
    private int count;

    public FlushResponse() {
    }

    public FlushResponse(ClusterName clusterName, NodeFlushResponse[] nodes) {
        super(clusterName, (NodeOperationResponse[])nodes);
        for (int i = 0; i < nodes.length; ++i) {
            NodeFlushResponse nodeFlushResponse = nodes[i];
            this.count += nodeFlushResponse.getCount();
        }
    }

    public FlushResponse(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("count", this.count);
        return builder;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.count);
    }
}

