/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.support;

import de.saly.elasticsearch.importer.imap.impl.IMAPImporter;
import de.saly.elasticsearch.importer.imap.mailsource.MailSource;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.UnableToInterruptJobException;

@DisallowConcurrentExecution
public class MailFlowJob
implements InterruptableJob {
    private MailSource mailSource = null;
    private Pattern pattern;
    protected final ESLogger logger = ESLoggerFactory.getLogger((String)this.getClass().getName());

    public void execute() throws MessagingException, IOException {
        if (this.mailSource != null) {
            if (this.pattern == null) {
                this.mailSource.fetchAll();
            } else {
                this.mailSource.fetch(this.pattern);
            }
        } else {
            throw new IllegalArgumentException("mailSource must not be null");
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobKey key = context.getJobDetail().getKey();
        this.logger.debug("Executing mail flow job {}", new Object[]{key.toString()});
        JobDataMap data = context.getMergedJobDataMap();
        this.mailSource = (MailSource)data.get((Object)"mailSource");
        this.pattern = (Pattern)data.get((Object)"pattern");
        Client client = (Client)data.get((Object)"client");
        try {
            IMAPImporter.waitForYellowCluster(client);
            this.execute();
        }
        catch (Exception e) {
            this.logger.error("Error in mail flow job {}: {} job", (Throwable)e, new Object[]{key.toString(), e.toString()});
            JobExecutionException e2 = new JobExecutionException((Throwable)e);
            throw e2;
        }
        this.logger.debug("End of mail flow job with no errors {}", new Object[]{key.toString()});
    }

    public MailSource getMailSource() {
        return this.mailSource;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (this.mailSource != null) {
            this.mailSource.close();
        }
    }

    public void setMailSource(MailSource mailSource) {
        this.mailSource = mailSource;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

