/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.support;

import com.sun.mail.pop3.POP3Folder;
import de.saly.elasticsearch.importer.imap.support.IMAPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.UIDFolder;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;

public class IndexableMailMessage {
    protected static final ESLogger logger = ESLoggerFactory.getLogger((String)IndexableMailMessage.class.getName());
    private int attachmentCount;
    private ESAttachment[] attachments;
    private Address[] bcc;
    private Address[] cc;
    private String contentType;
    private int flaghashcode;
    private String[] flags;
    private String folderFullName;
    private String folderUri;
    private Address from;
    private IndexableHeader[] headers;
    private Map<String, String> selectedHeaders;
    private String mailboxType;
    private final ObjectMapper mapper = new ObjectMapper();
    private String popId;
    private Date receivedDate;
    private Date sentDate;
    private int size;
    private String subject;
    private String textContent;
    private String htmlContent;
    private Address[] to;
    private long uid;

    public static IndexableMailMessage fromJavaMailMessage(Message jmm, boolean withTextContent, boolean withHtmlContent, boolean preferHtmlContent, boolean withAttachments, boolean stripTags, List<String> headersToFields) throws MessagingException, IOException {
        IndexableMailMessage im = new IndexableMailMessage();
        Enumeration allHeaders = jmm.getAllHeaders();
        HashSet<IndexableHeader> headerList = new HashSet<IndexableHeader>();
        while (allHeaders.hasMoreElements()) {
            Header h = (Header)allHeaders.nextElement();
            headerList.add(new IndexableHeader(h.getName(), h.getValue()));
        }
        im.setHeaders(headerList.toArray(new IndexableHeader[headerList.size()]));
        im.setSelectedHeaders(IndexableMailMessage.extractHeaders(im.getHeaders(), headersToFields));
        if (jmm.getFolder() instanceof POP3Folder) {
            im.setPopId(((POP3Folder)jmm.getFolder()).getUID(jmm));
            im.setMailboxType("POP");
        } else {
            im.setMailboxType("IMAP");
        }
        if (jmm.getFolder() instanceof UIDFolder) {
            im.setUid(((UIDFolder)jmm.getFolder()).getUID(jmm));
        }
        im.setFolderFullName(jmm.getFolder().getFullName());
        im.setFolderUri(jmm.getFolder().getURLName().toString());
        im.setContentType(jmm.getContentType());
        im.setSubject(jmm.getSubject());
        im.setSize(jmm.getSize());
        im.setSentDate(jmm.getSentDate());
        if (jmm.getReceivedDate() != null) {
            im.setReceivedDate(jmm.getReceivedDate());
        }
        if (jmm.getFrom() != null && jmm.getFrom().length > 0) {
            im.setFrom(Address.fromJavaMailAddress(jmm.getFrom()[0]));
        }
        if (jmm.getRecipients(Message.RecipientType.TO) != null) {
            im.setTo(Address.fromJavaMailAddress(jmm.getRecipients(Message.RecipientType.TO)));
        }
        if (jmm.getRecipients(Message.RecipientType.CC) != null) {
            im.setCc(Address.fromJavaMailAddress(jmm.getRecipients(Message.RecipientType.CC)));
        }
        if (jmm.getRecipients(Message.RecipientType.BCC) != null) {
            im.setBcc(Address.fromJavaMailAddress(jmm.getRecipients(Message.RecipientType.BCC)));
        }
        if (withTextContent) {
            String textContent = IndexableMailMessage.getText((Part)jmm, 0, preferHtmlContent);
            if (stripTags) {
                textContent = IndexableMailMessage.stripTags(textContent);
            }
            im.setTextContent(textContent);
        }
        if (withHtmlContent) {
            String htmlContent = IndexableMailMessage.getText((Part)jmm, 0, true);
            im.setHtmlContent(htmlContent);
        }
        if (withAttachments) {
            try {
                Object content = jmm.getContent();
                if (jmm.isMimeType("multipart/*") && content instanceof Multipart) {
                    ArrayList<ESAttachment> attachments = new ArrayList<ESAttachment>();
                    Multipart multipart = (Multipart)content;
                    for (int i = 0; i < multipart.getCount(); ++i) {
                        BodyPart bodyPart = multipart.getBodyPart(i);
                        if (!"attachment".equalsIgnoreCase(bodyPart.getDisposition()) && !StringUtils.isNotBlank((String)bodyPart.getFileName())) continue;
                        InputStream is = bodyPart.getInputStream();
                        byte[] bytes = IOUtils.toByteArray((InputStream)is);
                        IOUtils.closeQuietly((InputStream)is);
                        attachments.add(new ESAttachment(bodyPart.getContentType(), bytes, bodyPart.getFileName()));
                    }
                    if (!attachments.isEmpty()) {
                        im.setAttachments(attachments.toArray(new ESAttachment[attachments.size()]));
                        im.setAttachmentCount(im.getAttachments().length);
                        attachments.clear();
                        attachments = null;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error indexing attachments (message will be indexed but without attachments) due to {}", (Throwable)e, new Object[]{e.toString()});
            }
        }
        im.setFlags(IMAPUtils.toStringArray(jmm.getFlags()));
        im.setFlaghashcode(jmm.getFlags().hashCode());
        return im;
    }

    private static Map<String, String> extractHeaders(IndexableHeader[] allHeaders, List<String> headersToFields) {
        HashMap<String, String> map = new HashMap<String, String>();
        block0: for (String headerName : headersToFields) {
            for (IndexableHeader header : allHeaders) {
                if (!headerName.toLowerCase().equals(header.getName().toLowerCase())) continue;
                String fieldName = "header_" + headerName.replaceAll("[^A-Za-z0-9 ]", "_").toLowerCase();
                map.put(fieldName, header.getValue());
                continue block0;
            }
        }
        return map;
    }

    private static String getText(Part p, int depth, boolean preferHtmlContent) throws MessagingException, IOException {
        if (depth >= 100) {
            throw new IOException("Endless recursion detected ");
        }
        if (p.isMimeType("text/*")) {
            Object content = null;
            try {
                content = p.getContent();
            }
            catch (Exception e) {
                logger.error("Unable to index the content of a message due to {}", new Object[]{e.toString()});
                return null;
            }
            if (content instanceof String) {
                String s = (String)p.getContent();
                return s;
            }
            if (content instanceof InputStream) {
                InputStream in = (InputStream)content;
                String s = IOUtils.toString((InputStream)in, (String)"UTF-8");
                IOUtils.closeQuietly((InputStream)in);
                return s;
            }
            throw new MessagingException("Unknown content class representation: " + content.getClass());
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/html")) {
                    if (text == null) {
                        text = IndexableMailMessage.getText((Part)bp, ++depth, preferHtmlContent);
                    }
                    if (!preferHtmlContent) continue;
                    return text;
                }
                if (bp.isMimeType("text/plain")) {
                    String s;
                    if ((s = IndexableMailMessage.getText((Part)bp, ++depth, preferHtmlContent)) == null || preferHtmlContent) continue;
                    return s;
                }
                return IndexableMailMessage.getText((Part)bp, ++depth, preferHtmlContent);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = IndexableMailMessage.getText((Part)mp.getBodyPart(i), ++depth, preferHtmlContent);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private static String stripTags(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\\<.*?\\>", "");
    }

    public IndexableMailMessage() {
        this.mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String build() throws IOException {
        return this.mapper.writeValueAsString((Object)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexableMailMessage other = (IndexableMailMessage)obj;
        if (this.folderFullName == null ? other.folderFullName != null : !this.folderFullName.equals(other.folderFullName)) {
            return false;
        }
        if (this.popId == null ? other.popId != null : !this.popId.equals(other.popId)) {
            return false;
        }
        return this.uid == other.uid;
    }

    public int getAttachmentCount() {
        return this.attachmentCount;
    }

    public ESAttachment[] getAttachments() {
        return this.attachments;
    }

    public Address[] getBcc() {
        return this.bcc;
    }

    public Address[] getCc() {
        return this.cc;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getFlaghashcode() {
        return this.flaghashcode;
    }

    public String[] getFlags() {
        return this.flags;
    }

    public String getFolderFullName() {
        return this.folderFullName;
    }

    public String getFolderUri() {
        return this.folderUri;
    }

    public Address getFrom() {
        return this.from;
    }

    public IndexableHeader[] getHeaders() {
        return this.headers;
    }

    @JsonAnyGetter
    public Map<String, String> getSelectedHeaders() {
        return this.selectedHeaders;
    }

    public String getMailboxType() {
        return this.mailboxType;
    }

    public String getPopId() {
        return this.popId;
    }

    public Date getReceivedDate() {
        return this.receivedDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public int getSize() {
        return this.size;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    public Address[] getTo() {
        return this.to;
    }

    public long getUid() {
        return this.uid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folderFullName == null ? 0 : this.folderFullName.hashCode());
        result = 31 * result + (this.popId == null ? 0 : this.popId.hashCode());
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public void setAttachmentCount(int attachmentCount) {
        this.attachmentCount = attachmentCount;
    }

    public void setAttachments(ESAttachment[] attachments) {
        this.attachments = attachments;
    }

    public void setBcc(Address[] bcc) {
        this.bcc = bcc;
    }

    public void setCc(Address[] cc) {
        this.cc = cc;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFlaghashcode(int flaghashcode) {
        this.flaghashcode = flaghashcode;
    }

    public void setFlags(String[] flags) {
        this.flags = flags;
    }

    public void setFolderFullName(String folderFullName) {
        this.folderFullName = folderFullName;
    }

    public void setFolderUri(String folderUri) {
        this.folderUri = folderUri;
    }

    public void setFrom(Address from) {
        this.from = from;
    }

    public void setHeaders(IndexableHeader[] headers) {
        this.headers = headers;
    }

    public void setSelectedHeaders(Map<String, String> selectedHeaders) {
        this.selectedHeaders = selectedHeaders;
    }

    public void setMailboxType(String mailboxType) {
        this.mailboxType = mailboxType;
    }

    public void setPopId(String popId) {
        this.popId = popId;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public void setHtmlContent(String htmlContent) {
        this.htmlContent = htmlContent;
    }

    public void setTo(Address[] to) {
        this.to = to;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public String toString() {
        return "IndexableMailMessage [uid=" + this.uid + ", headers=" + this.headers + ", contentType=" + this.contentType + ", subject=" + this.subject + ", size=" + this.size + ", sentDate=" + this.sentDate + ", receivedDate=" + this.receivedDate + ", from=" + this.from + ", to=" + Arrays.toString(this.to) + ", cc=" + Arrays.toString(this.cc) + ", bcc=" + Arrays.toString(this.bcc) + "]";
    }

    public static class IndexableHeader {
        final String name;
        final String value;

        public IndexableHeader(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexableHeader other = (IndexableHeader)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }
    }

    public static class ESAttachment {
        private byte[] content;
        private String contentType;
        private String fileName;
        private int size;

        public ESAttachment() {
        }

        public ESAttachment(String contentType, byte[] bytes, String filename) {
            this.setContentType(contentType);
            this.setContent(bytes);
            this.setFilename(filename);
        }

        public byte[] getContent() {
            return this.content;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFilename() {
            return this.fileName;
        }

        public String getName() {
            return this.fileName;
        }

        public int getSize() {
            return this.size;
        }

        public void setContent(byte[] content) {
            this.content = content;
            this.size = content != null ? content.length : 0;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setFilename(String filename) {
            this.fileName = filename;
        }

        public void setName(String name) {
            this.fileName = name;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    public static class Address {
        private String email;
        private String personal;

        public static Address fromJavaMailAddress(javax.mail.Address jma) {
            Address a = new Address();
            InternetAddress ia = (InternetAddress)jma;
            a.setEmail(ia.getAddress());
            a.setPersonal(ia.getPersonal());
            return a;
        }

        public static Address[] fromJavaMailAddress(javax.mail.Address[] jmas) {
            Address[] as = new Address[jmas.length];
            int i = 0;
            for (javax.mail.Address jma : jmas) {
                Address a = new Address();
                InternetAddress ia = (InternetAddress)jma;
                a.setEmail(ia.getAddress());
                a.setPersonal(ia.getPersonal());
                as[i++] = a;
            }
            return as;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Address other = (Address)obj;
            return !(this.email == null ? other.email != null : !this.email.equals(other.email));
        }

        public String getEmail() {
            return this.email;
        }

        public String getPersonal() {
            return this.personal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
            return result;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setPersonal(String personal) {
            this.personal = personal;
        }

        public String toString() {
            return "Address [email=" + this.email + ", personal=" + this.personal + "]";
        }
    }
}

