/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.mailsource;

import de.saly.elasticsearch.importer.imap.maildestination.MailDestination;
import de.saly.elasticsearch.importer.imap.mailsource.MailSource;
import de.saly.elasticsearch.importer.imap.state.State;
import de.saly.elasticsearch.importer.imap.state.StateManager;
import de.saly.elasticsearch.importer.imap.support.IMAPUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.indices.IndexMissingException;

public class ParallelPollingIMAPMailSource
implements MailSource {
    private final ExecutorService es;
    private MailDestination mailDestination;
    private final String password;
    private final Properties props;
    private StateManager stateManager;
    private final int threadCount;
    private final String user;
    private boolean withFlagSync = true;
    private boolean deleteExpungedMessages = true;
    protected final ESLogger logger = ESLoggerFactory.getLogger((String)this.getClass().getName());

    public ParallelPollingIMAPMailSource(Properties props, int threadCount, String user, String password) {
        this.props = props;
        this.threadCount = threadCount < 1 ? 1 : threadCount;
        this.es = Executors.newFixedThreadPool(threadCount);
        this.user = user;
        this.password = password;
    }

    @Override
    public void close() {
        if (this.es != null) {
            this.logger.info("Initiate shutdown", new Object[0]);
            this.es.shutdown();
        }
    }

    @Override
    public void fetch(Pattern pattern) throws MessagingException, IOException {
        this.fetch(pattern, null);
    }

    @Override
    public void fetch(String folderName) throws MessagingException, IOException {
        this.fetch(null, folderName);
    }

    @Override
    public void fetchAll() throws MessagingException, IOException {
        this.fetch(null, null);
    }

    @Override
    public MailDestination getMailDestination() {
        return this.mailDestination;
    }

    public Properties getProps() {
        return this.props;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setMailDestination(MailDestination mailDestination) {
        this.mailDestination = mailDestination;
    }

    @Override
    public void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public ParallelPollingIMAPMailSource setWithFlagSync(boolean withFlagSync) {
        this.withFlagSync = withFlagSync;
        return this;
    }

    @Override
    public void setDeleteExpungedMessages(boolean deleteExpungedMessages) {
        this.deleteExpungedMessages = deleteExpungedMessages;
    }

    private ProcessResult process(int messageCount, int start, final String folderName) {
        long startTime = System.currentTimeMillis();
        int netCount = messageCount - (start == 1 ? 0 : start) + 1;
        this.logger.debug("netCount: {}", new Object[]{netCount});
        if (netCount == 0) {
            return new ProcessResult(0L, 0, 0L);
        }
        int block = netCount / this.threadCount;
        ArrayList<Object> fl = new ArrayList<Object>();
        this.logger.debug(netCount + "/" + this.threadCount + "=" + block, new Object[0]);
        int lastStart = 0;
        for (int i = 1; i <= this.threadCount; ++i) {
            int _start;
            lastStart = _start = i == 1 ? start : lastStart + block + 1;
            final int _end = Math.min(_start + block, messageCount);
            if (_end < _start) continue;
            this.logger.debug("Schedule: " + _start + " - " + _end, new Object[0]);
            Future<ProcessResult> f = this.es.submit(new Callable<ProcessResult>(){

                @Override
                public ProcessResult call() throws Exception {
                    return ParallelPollingIMAPMailSource.this.processMessageSlice(_start, _end, folderName);
                }
            });
            fl.add(f);
        }
        long highestUid = 0L;
        int processedCount = 0;
        for (Future future : fl) {
            try {
                highestUid = Math.max(highestUid, ((ProcessResult)future.get()).highestUid);
                processedCount += ((ProcessResult)future.get()).processedCount;
                this.logger.debug("Finished with " + future.get(), new Object[0]);
            }
            catch (Exception e) {
                this.logger.error("Unable to process some mails due to {}", (Throwable)e, new Object[]{e.toString()});
            }
        }
        long endTime = System.currentTimeMillis() + 1L;
        return new ProcessResult(highestUid, processedCount, endTime - startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessResult processMessageSlice(int start, int end, String folderName) throws Exception {
        this.logger.debug("processMessageSlice() started with " + start + "/" + end + "/" + folderName, new Object[0]);
        long startTime = System.currentTimeMillis();
        Store store = Session.getInstance((Properties)this.props).getStore();
        store.connect(this.user, this.password);
        Folder folder = store.getFolder(folderName);
        UIDFolder uidfolder = (UIDFolder)folder;
        IMAPUtils.open(folder);
        try {
            Message[] msgs = folder.getMessages(start, end);
            folder.fetch(msgs, IMAPUtils.FETCH_PROFILE_HEAD);
            this.logger.debug("folder fetch done", new Object[0]);
            long highestUid = 0L;
            int processedCount = 0;
            for (Message m : msgs) {
                try {
                    IMAPUtils.open(folder);
                    long uid = uidfolder.getUID(m);
                    this.mailDestination.onMessage(m);
                    highestUid = Math.max(highestUid, uid);
                    ++processedCount;
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
                catch (Exception e) {
                    this.stateManager.onError("Unable to make indexable message", m, e);
                    this.logger.error("Unable to make indexable message due to {}", (Throwable)e, new Object[]{e.toString()});
                    IMAPUtils.open(folder);
                }
            }
            long endTime = System.currentTimeMillis() + 1L;
            ProcessResult pr = new ProcessResult(highestUid, processedCount, endTime - startTime);
            this.logger.debug("processMessageSlice() ended with " + pr, new Object[0]);
            ProcessResult processResult = pr;
            return processResult;
        }
        finally {
            IMAPUtils.close(folder);
            IMAPUtils.close(store);
        }
    }

    protected void fetch(Folder folder) throws MessagingException, IOException {
        if ((folder.getType() & 1) == 0) {
            this.logger.warn("Folder {} cannot hold messages", new Object[]{folder.getFullName()});
            return;
        }
        int messageCount = folder.getMessageCount();
        UIDFolder uidfolder = (UIDFolder)folder;
        long servervalidity = uidfolder.getUIDValidity();
        State riverState = this.stateManager.getRiverState(folder);
        Long localvalidity = riverState.getUidValidity();
        this.logger.info("Fetch mails from folder {} ({})", new Object[]{folder.getURLName().toString(), messageCount});
        this.logger.debug("Server uid validity: {}, Local uid validity: {}", new Object[]{servervalidity, localvalidity});
        if (localvalidity == null || localvalidity != servervalidity) {
            this.logger.debug("UIDValidity fail, full resync " + localvalidity + "!=" + servervalidity, new Object[0]);
            if (localvalidity != null) {
                this.mailDestination.clearDataForFolder(folder.getFullName());
            }
            ProcessResult result = this.process(messageCount, 1, folder.getFullName());
            riverState.setLastCount(result.getProcessedCount());
            if (result.getProcessedCount() > 0) {
                riverState.setLastIndexed(new Date());
            }
            if (result.getProcessedCount() > 0) {
                riverState.setLastTook(result.getTook());
            }
            riverState.setLastSchedule(new Date());
            if (result.getProcessedCount() > 0 && result.getHighestUid() > 0L) {
                riverState.setLastUid(result.getHighestUid());
            }
            riverState.setUidValidity(servervalidity);
            this.stateManager.setRiverState(riverState);
            this.logger.info("Initiailly processed {} mails for folder {}", new Object[]{result.getProcessedCount(), folder.getFullName()});
            this.logger.debug("Processed result {}", new Object[]{result.toString()});
        } else {
            if (messageCount == 0) {
                this.logger.debug("Folder {} is empty", new Object[]{folder.getFullName()});
            } else {
                if (this.withFlagSync) {
                    Message[] flagMessages = folder.getMessages();
                    folder.fetch(flagMessages, IMAPUtils.FETCH_PROFILE_FLAGS_UID);
                    for (Message message : flagMessages) {
                        try {
                            int flagHashcode;
                            long uid = ((UIDFolder)message.getFolder()).getUID(message);
                            String id = uid + "::" + message.getFolder().getURLName();
                            int storedHashcode = this.mailDestination.getFlaghashcode(id);
                            if (storedHashcode == -1 || (flagHashcode = message.getFlags().hashCode()) == storedHashcode) continue;
                            this.mailDestination.onMessage(message);
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug("Update " + id + " because of flag change", new Object[0]);
                        }
                        catch (Exception e) {
                            this.logger.error("Error detecting flagchanges for message " + ((MimeMessage)message).getMessageID(), (Throwable)e, new Object[0]);
                            this.stateManager.onError("Error detecting flagchanges", message, e);
                        }
                    }
                }
                long highestUID = riverState.getLastUid();
                this.logger.debug("highestUID: {}", new Object[]{highestUID});
                Message[] msgsnew = uidfolder.getMessagesByUID(highestUID, -1L);
                if (highestUID <= 0L || uidfolder.getUID(msgsnew[0]) <= highestUID) {
                    // empty if block
                }
                if (msgsnew.length > 0) {
                    this.logger.info("{} new messages in folder {}", new Object[]{msgsnew.length, folder.getFullName()});
                    int start = msgsnew[0].getMessageNumber();
                    ProcessResult result = this.process(messageCount, start, folder.getFullName());
                    riverState.setLastCount(result.getProcessedCount());
                    if (result.getProcessedCount() > 0) {
                        riverState.setLastIndexed(new Date());
                    }
                    if (result.getProcessedCount() > 0) {
                        riverState.setLastTook(result.getTook());
                    }
                    riverState.setLastSchedule(new Date());
                    if (result.getProcessedCount() > 0 && result.getHighestUid() > 0L) {
                        riverState.setLastUid(result.getHighestUid());
                    }
                    riverState.setUidValidity(servervalidity);
                    this.stateManager.setRiverState(riverState);
                    this.logger.info("Not initiailly processed {} mails for folder {}", new Object[]{result.getProcessedCount(), folder.getFullName()});
                    this.logger.debug("Processed result {}", new Object[]{result.toString()});
                } else {
                    this.logger.debug("no new messages", new Object[0]);
                }
            }
            HashSet<Long> serverMailSet = new HashSet<Long>();
            long oldmailUid = riverState.getLastUid();
            this.logger.debug("oldmailuid {}", new Object[]{oldmailUid});
            Message[] msgsold = uidfolder.getMessagesByUID(1L, oldmailUid);
            folder.fetch(msgsold, IMAPUtils.FETCH_PROFILE_UID);
            for (Message m : msgsold) {
                try {
                    long uid = uidfolder.getUID(m);
                    serverMailSet.add(uid);
                }
                catch (Exception e) {
                    this.stateManager.onError("Unable to handle old message ", m, e);
                    this.logger.error("Unable to handle old message due to {}", (Throwable)e, new Object[]{e.toString()});
                    IMAPUtils.open(folder);
                }
            }
            if (this.deleteExpungedMessages) {
                HashSet localMailSet = new HashSet(this.mailDestination.getCurrentlyStoredMessageUids(folder.getFullName(), false));
                this.logger.debug("Check now " + localMailSet.size() + " server mails for expunge", new Object[0]);
                localMailSet.removeAll(serverMailSet);
                this.logger.info(localMailSet.size() + " messages were locally deleted, because they are expunged on server.", new Object[0]);
                this.mailDestination.onMessageDeletes(localMailSet, folder.getFullName(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetch(Pattern pattern, String folderName) throws MessagingException, IOException {
        this.logger.debug("fetch() - pattern: {}, folderName: {}", new Object[]{pattern, folderName});
        Store store = Session.getInstance((Properties)this.props).getStore();
        store.connect(this.user, this.password);
        try {
            for (String fol : this.mailDestination.getFolderNames()) {
                if (store.getFolder(fol).exists()) {
                    this.logger.debug("{} exists", new Object[]{fol});
                    continue;
                }
                this.logger.info("Folder {} does not exist on the server, will remove it (and its content) also locally", new Object[]{fol});
                State riverState = this.stateManager.getRiverState(store.getFolder(fol));
                riverState.setExists(false);
                this.stateManager.setRiverState(riverState);
                try {
                    this.mailDestination.clearDataForFolder(fol);
                }
                catch (Exception e) {
                    this.stateManager.onError("Unable to clean data for stale folder", store.getFolder(fol), e);
                }
            }
        }
        catch (IndexMissingException ime) {
            this.logger.debug(ime.toString(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Error checking for stale folders", (Throwable)e, new Object[0]);
        }
        boolean isRoot = StringUtils.isEmpty((String)folderName);
        Folder folder = isRoot ? store.getDefaultFolder() : store.getFolder(folderName);
        try {
            if (!folder.exists()) {
                this.logger.error("Folder {} does not exist on the server", new Object[]{folder.getFullName()});
                return;
            }
            this.logger.debug("folderName: {} is root: {}", new Object[]{folderName, isRoot});
            if (pattern != null && !isRoot && !pattern.matcher(folder.getFullName()).matches()) {
                this.logger.info(folder.getFullName() + " does not match pattern " + pattern.toString(), new Object[0]);
                return;
            }
            IMAPUtils.open(folder);
            this.recurseFolders(folder, pattern);
        }
        finally {
            IMAPUtils.close(folder);
            IMAPUtils.close(store);
        }
    }

    protected void recurseFolders(Folder folder, Pattern pattern) throws MessagingException, IOException {
        if (folder != null) {
            if (this.es == null || this.es.isShutdown() || this.es.isTerminated() || Thread.currentThread().isInterrupted()) {
                this.logger.warn("Stop processing of mails due to mail source is closed", new Object[0]);
                return;
            }
            if ((folder.getType() & 1) != 0) {
                if (pattern != null && !pattern.matcher(folder.getFullName()).matches()) {
                    this.logger.info("Pattern {} does not match {}", new Object[]{pattern.pattern(), folder.getFullName()});
                    return;
                }
                IMAPUtils.open(folder);
                try {
                    this.fetch(folder);
                }
                catch (Throwable throwable) {
                    IMAPUtils.close(folder);
                    this.logger.debug("fetch {} done", new Object[]{folder.getFullName()});
                    throw throwable;
                }
                IMAPUtils.close(folder);
                this.logger.debug("fetch {} done", new Object[]{folder.getFullName()});
            }
            if ((folder.getType() & 2) != 0) {
                for (Folder subfolder : folder.list()) {
                    this.recurseFolders(subfolder, pattern);
                }
            }
        }
    }

    private static class ProcessResult {
        private long highestUid = 1L;
        private final int processedCount;
        private final long took;

        public ProcessResult(long highestUid, int processedCount, long took) {
            this.highestUid = highestUid < 1L ? 1L : highestUid;
            this.processedCount = processedCount;
            this.took = took;
        }

        public long getHighestUid() {
            return this.highestUid;
        }

        public int getProcessedCount() {
            return this.processedCount;
        }

        public long getTook() {
            return this.took;
        }

        public String toString() {
            return "ProcessResult [highestUid=" + this.highestUid + ", processedCount=" + this.processedCount + ", took=" + this.took + "]";
        }
    }
}

