/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.maildestination;

import de.saly.elasticsearch.importer.imap.impl.IMAPImporter;
import de.saly.elasticsearch.importer.imap.maildestination.MailDestination;
import de.saly.elasticsearch.importer.imap.support.IndexableMailMessage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;

public class ElasticsearchMailDestination
implements MailDestination {
    private Client client;
    private volatile boolean closed;
    private volatile boolean error;
    private String index;
    private Map<String, Object> mapping;
    private Map<String, Object> settings;
    private volatile boolean started;
    private volatile boolean initialized;
    private boolean stripTagsFromTextContent = true;
    private String type;
    private boolean withAttachments = false;
    private boolean withTextContent = true;
    private boolean withHtmlContent = false;
    private boolean preferHtmlContent = false;
    private List<String> headersToFields;
    protected final ESLogger logger = ESLoggerFactory.getLogger((String)this.getClass().getName());

    @Override
    public void clearDataForFolder(String folderName) throws IOException, MessagingException {
        this.logger.info("Delete locally all messages for folder " + folderName, new Object[0]);
        this.createIndexIfNotExists();
        this.client.admin().indices().refresh(new RefreshRequest(new String[0])).actionGet();
        this.client.prepareDeleteByQuery(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"folderFullName", (String)folderName)).execute().actionGet();
    }

    public ElasticsearchMailDestination client(Client client) {
        this.client = client;
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.logger.info("Closed", new Object[0]);
    }

    @Override
    public Set getCurrentlyStoredMessageUids(String folderName, boolean isPop) throws IOException, MessagingException {
        boolean hitsRead;
        this.createIndexIfNotExists();
        this.client.admin().indices().refresh(new RefreshRequest(new String[0])).actionGet();
        HashSet<Object> uids = new HashSet<Object>();
        TermQueryBuilder b = QueryBuilders.termQuery((String)"folderFullName", (String)folderName);
        this.logger.debug("Term query: " + b.buildAsBytes().toUtf8(), new Object[0]);
        SearchResponse scrollResp = (SearchResponse)this.client.prepareSearch(new String[0]).setIndices(new String[]{this.index}).setTypes(new String[]{this.type}).setSearchType(SearchType.SCAN).setQuery((QueryBuilder)b).setScroll(new TimeValue(1000L)).setSize(1000).execute().actionGet();
        do {
            scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(1000L)).execute().actionGet();
            hitsRead = false;
            for (SearchHit hit : scrollResp.getHits()) {
                hitsRead = true;
                if (!isPop) {
                    uids.add(Long.parseLong(hit.getId().split("::")[0]));
                } else {
                    uids.add(hit.getId().split("::")[0]);
                }
                this.logger.debug("Local: " + hit.getId(), new Object[0]);
            }
        } while (hitsRead);
        this.logger.debug("Currently locally stored messages for folder {}: {}", new Object[]{folderName, uids.size()});
        return uids;
    }

    @Override
    public int getFlaghashcode(String id) throws IOException, MessagingException {
        this.createIndexIfNotExists();
        this.client.admin().indices().refresh(new RefreshRequest(new String[0])).actionGet();
        GetResponse getResponse = (GetResponse)((GetRequestBuilder)this.client.prepareGet().setIndex(this.index)).setType(this.type).setId(id).setFields(new String[]{"flaghashcode"}).execute().actionGet();
        if (getResponse == null || !getResponse.isExists()) {
            return -1;
        }
        GetField flaghashcodeField = getResponse.getField("flaghashcode");
        if (flaghashcodeField == null || flaghashcodeField.getValue() == null || !(flaghashcodeField.getValue() instanceof Integer)) {
            throw new IOException("No flaghashcode field for id " + id);
        }
        return (Integer)flaghashcodeField.getValue();
    }

    @Override
    public Set<String> getFolderNames() throws IOException, MessagingException {
        boolean hitsRead;
        this.createIndexIfNotExists();
        this.client.admin().indices().refresh(new RefreshRequest(new String[0])).actionGet();
        HashSet<String> uids = new HashSet<String>();
        SearchResponse scrollResp = (SearchResponse)this.client.prepareSearch(new String[0]).setIndices(new String[]{this.index}).setTypes(new String[]{this.type}).setSearchType(SearchType.SCAN).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addField("folderFullName").setScroll(new TimeValue(1000L)).setSize(1000).execute().actionGet();
        do {
            scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(1000L)).execute().actionGet();
            hitsRead = false;
            for (SearchHit hit : scrollResp.getHits()) {
                hitsRead = true;
                uids.add((String)((SearchHitField)hit.getFields().get("folderFullName")).getValue());
            }
        } while (hitsRead);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Currently locally stored folders: {}", new Object[]{uids});
        }
        return uids;
    }

    public List<String> getHeadersToFields() {
        return this.headersToFields;
    }

    public boolean isStripTagsFromTextContent() {
        return this.stripTagsFromTextContent;
    }

    public boolean isWithAttachments() {
        return this.withAttachments;
    }

    public boolean isWithTextContent() {
        return this.withTextContent;
    }

    public boolean isWithHtmlContent() {
        return this.withHtmlContent;
    }

    public boolean isPreferHtmlContent() {
        return this.preferHtmlContent;
    }

    @Override
    public void onMessage(Message msg) throws IOException, MessagingException {
        if (this.closed) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Is closed, will not index", new Object[0]);
            }
            return;
        }
        if (this.isError()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("error, not indexing", new Object[0]);
            }
            return;
        }
        this.createIndexIfNotExists();
        IndexableMailMessage imsg = IndexableMailMessage.fromJavaMailMessage(msg, this.withTextContent, this.withHtmlContent, this.preferHtmlContent, this.withAttachments, this.stripTagsFromTextContent, this.headersToFields);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Process mail " + imsg.getUid() + "/" + imsg.getPopId() + " :: " + imsg.getSubject() + "/" + imsg.getSentDate(), new Object[0]);
        }
        this.client.index(this.createIndexRequest(imsg)).actionGet();
    }

    @Override
    public void onMessageDeletes(Set msgs, String folderName, boolean isPop) throws IOException, MessagingException {
        if (msgs.size() == 0) {
            return;
        }
        this.createIndexIfNotExists();
        this.client.admin().indices().refresh(new RefreshRequest(new String[0])).actionGet();
        this.logger.info("Will delete " + msgs.size() + " messages locally for folder " + folderName, new Object[0]);
        BoolQueryBuilder query = new BoolQueryBuilder();
        if (isPop) {
            query.must((QueryBuilder)QueryBuilders.inQuery((String)"popId", (Collection)msgs));
        } else {
            query.must((QueryBuilder)QueryBuilders.inQuery((String)"uid", (Collection)msgs));
        }
        query.must((QueryBuilder)QueryBuilders.termQuery((String)"folderFullName", (String)folderName));
        this.client.prepareDeleteByQuery(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery((QueryBuilder)query).execute().actionGet();
    }

    public ElasticsearchMailDestination setIndex(String index) {
        this.index = index;
        return this;
    }

    public ElasticsearchMailDestination setMapping(Map<String, Object> mapping) {
        this.mapping = mapping;
        return this;
    }

    public ElasticsearchMailDestination setSettings(Map<String, Object> settings) {
        this.settings = settings;
        return this;
    }

    public ElasticsearchMailDestination setStripTagsFromTextContent(boolean stripTagsFromTextContent) {
        this.stripTagsFromTextContent = stripTagsFromTextContent;
        return this;
    }

    public ElasticsearchMailDestination setType(String type) {
        this.type = type;
        return this;
    }

    public ElasticsearchMailDestination setWithAttachments(boolean withAttachments) {
        this.withAttachments = withAttachments;
        return this;
    }

    public ElasticsearchMailDestination setWithTextContent(boolean withTextContent) {
        this.withTextContent = withTextContent;
        return this;
    }

    public ElasticsearchMailDestination setWithHtmlContent(boolean withHtmlContent) {
        this.withHtmlContent = withHtmlContent;
        return this;
    }

    public ElasticsearchMailDestination setPreferHtmlContent(boolean preferHtmlContent) {
        this.preferHtmlContent = preferHtmlContent;
        return this;
    }

    public MailDestination setHeadersToFields(List<String> headersToFields) {
        this.headersToFields = headersToFields;
        return this;
    }

    @Override
    public synchronized ElasticsearchMailDestination startup() throws IOException {
        if (this.started) {
            this.logger.debug("Destination already started", new Object[0]);
            return this;
        }
        this.started = true;
        this.logger.debug("Destination started", new Object[0]);
        return this;
    }

    private synchronized void createIndexIfNotExists() throws IOException {
        if (this.isError()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("error, not creating index", new Object[0]);
            }
            return;
        }
        if (this.initialized) {
            return;
        }
        IMAPImporter.waitForYellowCluster(this.client);
        if (!((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.index}).execute().actionGet()).isExists()) {
            CreateIndexRequestBuilder createIndexRequestBuilder = this.client.admin().indices().prepareCreate(this.index);
            if (this.settings != null) {
                this.logger.debug("index settings are provided, will apply them {}", new Object[]{this.settings});
                createIndexRequestBuilder.setSettings(this.settings);
            } else {
                this.logger.debug("no settings given for index '{}'", new Object[]{this.index});
            }
            if (this.mapping != null) {
                this.logger.debug("mapping for type '{}' is provided, will apply {}", new Object[]{this.type, this.mapping});
                createIndexRequestBuilder.addMapping(this.type, this.mapping);
            } else {
                this.logger.debug("no mapping given for type '{}', will apply default mapping", new Object[]{this.type});
                createIndexRequestBuilder.addMapping(this.type, this.getDefaultTypeMapping());
            }
            CreateIndexResponse res = (CreateIndexResponse)createIndexRequestBuilder.get();
            if (!res.isAcknowledged()) {
                throw new IOException("Could not create index " + this.index);
            }
            IMAPImporter.waitForYellowCluster(this.client);
            this.logger.info("Index {} created", new Object[]{this.index});
        } else {
            this.logger.debug("Index {} already exists", new Object[]{this.index});
        }
    }

    private XContentBuilder getDefaultTypeMapping() throws IOException {
        XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().startObject().startObject(this.type).startObject("properties").startObject("folderFullName").field("index", "not_analyzed").field("type", "string").endObject().startObject("receivedDate").field("type", "date").field("format", "basic_date_time").endObject().startObject("sentDate").field("type", "date").field("format", "basic_date_time").endObject().startObject("flaghashcode").field("type", "integer").endObject().endObject().endObject().endObject();
        return mappingBuilder;
    }

    protected IndexRequest createIndexRequest(IndexableMailMessage message) throws IOException {
        String id = (!StringUtils.isEmpty((String)message.getPopId()) ? message.getPopId() : Long.valueOf(message.getUid())) + "::" + message.getFolderUri();
        IndexRequest request = Requests.indexRequest((String)this.index).type(this.type).id(id).source(message.build());
        return request;
    }

    protected Client getClient() {
        return this.client;
    }

    protected synchronized boolean isClosed() {
        return this.closed;
    }

    protected synchronized boolean isError() {
        return this.error;
    }

    protected void setError(boolean error) {
        this.error = error;
    }
}

