/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.maildestination;

import de.saly.elasticsearch.importer.imap.maildestination.ElasticsearchMailDestination;
import de.saly.elasticsearch.importer.imap.support.IndexableMailMessage;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class ElasticsearchBulkMailDestination
extends ElasticsearchMailDestination {
    private static final AtomicInteger outstandingBulkRequests = new AtomicInteger(0);
    private static final AtomicInteger queue = new AtomicInteger(0);
    private BulkProcessor bulk;
    private TimeValue flushInterval = TimeValue.timeValueSeconds((long)5L);
    private final BulkProcessor.Listener listener = new BulkProcessor.Listener(){

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            long l = outstandingBulkRequests.decrementAndGet();
            int cur = queue.addAndGet(-response.getItems().length);
            ElasticsearchBulkMailDestination.this.logger.info("Bulk actions done successfully [{}] success [{} items] [{}ms], {} outstanding bulk requests, queue size is {}", new Object[]{executionId, response.getItems().length, response.getTookInMillis(), l, cur});
        }

        public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            long l = outstandingBulkRequests.decrementAndGet();
            ElasticsearchBulkMailDestination.this.logger.error("Bulk actions done with errors [" + executionId + "] error, {} outstanding bulk requests", failure, new Object[]{l});
            ElasticsearchBulkMailDestination.this.setError(true);
        }

        public void beforeBulk(long executionId, BulkRequest request) {
            long l = outstandingBulkRequests.incrementAndGet();
            ElasticsearchBulkMailDestination.this.logger.info("New bulk actions queued [{}] of [{} items], {} outstanding bulk requests", new Object[]{executionId, request.numberOfActions(), l});
        }
    };
    private int maxBulkActions = 100;
    private int maxConcurrentBulkRequests = 30;
    private final ByteSizeValue maxVolumePerBulkRequest = ByteSizeValue.parseBytesSizeValue((String)"10mb");

    @Override
    public ElasticsearchMailDestination client(Client client) {
        super.client(client);
        this.bulk = BulkProcessor.builder((Client)client, (BulkProcessor.Listener)this.listener).setBulkActions(this.maxBulkActions).setConcurrentRequests(this.maxConcurrentBulkRequests).setBulkSize(this.maxVolumePerBulkRequest).setFlushInterval(this.flushInterval).build();
        return this;
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this.bulk != null) {
            this.logger.debug("Shutdown (flush) bulk processor, is super closed " + this.isClosed(), new Object[0]);
            this.bulk.close();
        }
    }

    public ElasticsearchBulkMailDestination flushInterval(TimeValue flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public ElasticsearchBulkMailDestination maxBulkActions(int maxBulkActions) {
        this.maxBulkActions = maxBulkActions;
        return this;
    }

    public ElasticsearchBulkMailDestination maxConcurrentBulkRequests(int maxConcurrentBulkRequests) {
        this.maxConcurrentBulkRequests = maxConcurrentBulkRequests;
        return this;
    }

    @Override
    public void onMessage(Message msg) throws IOException, MessagingException {
        if (this.isClosed()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Is closed, will not index", new Object[0]);
            }
            return;
        }
        if (this.isError()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("error, not indexing", new Object[0]);
            }
            return;
        }
        IndexableMailMessage imsg = IndexableMailMessage.fromJavaMailMessage(msg, this.isWithTextContent(), this.isWithHtmlContent(), this.isPreferHtmlContent(), this.isWithAttachments(), this.isStripTagsFromTextContent(), this.getHeadersToFields());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Bulk process mail " + imsg.getUid() + "/" + imsg.getPopId() + " :: " + imsg.getSubject() + "/" + imsg.getSentDate(), new Object[0]);
        }
        try {
            if (!this.isClosed()) {
                this.bulk.add(this.createIndexRequest(imsg));
                queue.incrementAndGet();
            }
        }
        catch (ElasticsearchIllegalStateException e) {
            if (this.isClosed()) {
                this.logger.debug("Bulkprocessing error due to {}", new Object[]{e.toString()});
            }
            this.logger.error("Bulkprocessing error due to {}", (Throwable)e, new Object[]{e.toString()});
        }
    }
}

