/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.ldap;

import de.saly.elasticsearch.importer.imap.ldap.ILdapConnector;
import de.saly.elasticsearch.importer.imap.ldap.ILoginSource;
import de.saly.elasticsearch.importer.imap.ldap.SimpleLdapConnector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class LdapLoginSource
implements ILoginSource,
Runnable {
    private static final String DEF_USER_NAME_FIELD = "dn";
    private static final String DEF_USER_PW_FIELD = "userPassword";
    private static final String DEF_REFRESH_INT = "60";
    private static final String MASTER_SEP = "*";
    private final String fNameField;
    private final String fPasswordField;
    private final String fLdapFilter;
    private final long fRefreshInt;
    private final List<String> fUserNames = new ArrayList<String>();
    private final List<String> fUserPasswords = new ArrayList<String>();
    private final String fMasterUser;
    private final String fMasterPassword;
    private final ILdapConnector fConnector;
    private final ESLogger fLogger;
    private final Object fLock;
    private volatile boolean fInitialized;
    private volatile boolean fActive;

    public LdapLoginSource(Map<String, Object> settings) {
        this(settings, null, null);
    }

    public LdapLoginSource(Map<String, Object> settings, String masterUser, String masterPassword) {
        this.fMasterUser = masterUser;
        this.fMasterPassword = masterPassword;
        String url = XContentMapValues.nodeStringValue((Object)settings.get("ldap_url"), null);
        String base = XContentMapValues.nodeStringValue((Object)settings.get("ldap_base"), null);
        String user = XContentMapValues.nodeStringValue((Object)settings.get("ldap_user"), null);
        String password = XContentMapValues.nodeStringValue((Object)settings.get("ldap_password"), null);
        this.fConnector = new SimpleLdapConnector(url, base, user, password, true);
        this.fNameField = XContentMapValues.nodeStringValue((Object)settings.get("ldap_name_field"), (String)DEF_USER_NAME_FIELD);
        this.fPasswordField = XContentMapValues.nodeStringValue((Object)settings.get("ldap_password_field"), (String)DEF_USER_PW_FIELD);
        this.fLdapFilter = this.fNameField + "=*";
        this.fLogger = ESLoggerFactory.getLogger((String)LdapLoginSource.class.getName());
        this.fLock = new Object();
        this.fInitialized = false;
        String refreshParam = XContentMapValues.nodeStringValue((Object)settings.get("ldap_refresh_interval"), (String)DEF_REFRESH_INT);
        this.fRefreshInt = Long.parseLong(refreshParam) * 60000L;
        if (this.fRefreshInt > 0L) {
            this.fActive = true;
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws Exception {
        Exception ex = null;
        Object object = this.fLock;
        synchronized (object) {
            ArrayList nameBackup = Lists.newArrayList(this.fUserNames);
            ArrayList passBackup = Lists.newArrayList(this.fUserPasswords);
            try {
                this.fUserNames.clear();
                this.fUserPasswords.clear();
                this.fConnector.connect();
                NamingEnumeration data = this.fConnector.query("", this.fLdapFilter);
                if (data != null) {
                    this.readData(data);
                }
            }
            catch (Exception e) {
                this.fUserNames.clear();
                this.fUserPasswords.clear();
                this.fUserNames.addAll(nameBackup);
                this.fUserPasswords.addAll(passBackup);
                ex = e;
            }
            finally {
                this.fConnector.disconnect();
            }
        }
        if (ex != null) {
            throw ex;
        }
        this.fInitialized = true;
    }

    private void readData(NamingEnumeration ldapContents) throws Exception {
        SearchResult result = null;
        NamingEnumeration<? extends Attribute> atts = null;
        Attribute a = null;
        while (ldapContents.hasMore()) {
            String name = null;
            String password = null;
            result = (SearchResult)ldapContents.next();
            name = result.getName();
            name = name.split("=")[1];
            if (this.fMasterUser != null) {
                name = name + MASTER_SEP + this.fMasterUser;
            }
            atts = result.getAttributes().getAll();
            while (atts.hasMore()) {
                a = atts.next();
                if (!this.fPasswordField.equals(a.getID()) || a.get() == null) continue;
                Object val = a.get();
                password = val instanceof byte[] ? new String((byte[])val) : val.toString();
                break;
            }
            if (this.fMasterPassword != null) {
                password = this.fMasterPassword;
            }
            this.fUserNames.add(name);
            this.fUserPasswords.add(password);
        }
    }

    @Override
    public String getName() {
        return "LDAP login source";
    }

    @Override
    public List<String> getUserNames() {
        if (!this.fInitialized) {
            try {
                this.read();
            }
            catch (Exception e) {
                this.fLogger.error("Failed to get usernames", (Throwable)e, new Object[0]);
            }
        }
        return this.fUserNames;
    }

    @Override
    public List<String> getUserPasswords() {
        if (!this.fInitialized) {
            try {
                this.read();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.fLogger.error("Failed to get passwords", (Throwable)e, new Object[0]);
            }
        }
        return this.fUserPasswords;
    }

    public void deactivate() {
        this.fActive = false;
    }

    @Override
    public void run() {
        while (this.fActive) {
            try {
                this.read();
            }
            catch (Exception e) {
                this.fLogger.error("Failed to refresh", (Throwable)e, new Object[0]);
            }
            try {
                Thread.sleep(this.fRefreshInt);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

