/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap;

import de.saly.elasticsearch.importer.imap.impl.IMAPImporter;
import java.io.File;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class IMAPImporterCl {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static IMAPImporter imap;
    private static Node node;
    private static Client client;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: IMAPImporterC [-e] <config-file>");
            System.exit(-1);
        }
        String configFile = null;
        boolean embedded = false;
        if (args.length == 1) {
            configFile = args[0];
        }
        if (args.length == 2) {
            embedded = "-e".equals(args[0]);
            configFile = args[1];
        }
        System.out.println("Config File: " + configFile);
        System.out.println("Embedded: " + embedded);
        final Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Will shutdown ...");
                IMAPImporterCl.stop();
                try {
                    mainThread.join();
                    System.out.println("Shudown done");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        IMAPImporterCl.start(configFile, embedded);
    }

    public static void stop() {
        if (imap != null) {
            imap.close();
        }
        if (client != null) {
            client.close();
        }
        if (node != null) {
            node.close();
        }
    }

    public static void start(Map<String, Object> settings, boolean embeddedMode) throws Exception {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
        for (String key : settings.keySet()) {
            builder.put(key, String.valueOf(settings.get(key)));
        }
        Settings eSettings = builder.build();
        if (embeddedMode) {
            node = NodeBuilder.nodeBuilder().local(true).clusterName("imap-embedded-" + System.currentTimeMillis()).node();
            client = node.client();
        } else {
            client = new TransportClient(eSettings);
            String[] hosts = eSettings.get("elasticsearch.hosts").split(",");
            for (int i = 0; i < hosts.length; ++i) {
                String host = hosts[i];
                String hostOnly = host.split(":")[0];
                String portOnly = host.split(":")[1];
                System.out.println("Adding " + hostOnly + ":" + portOnly);
                ((TransportClient)client).addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostOnly, Integer.parseInt(portOnly)));
            }
        }
        imap = new IMAPImporter(settings, client);
        imap.start();
    }

    public static void start(String configFile, boolean embeddedMode) throws Exception {
        Map settings = (Map)MAPPER.readValue(new File(configFile), Map.class);
        IMAPImporterCl.start(settings, embeddedMode);
    }
}

