/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.HasContext;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class TransportMessage<TM extends TransportMessage<TM>>
extends ContextAndHeaderHolder
implements Streamable {
    private TransportAddress remoteAddress;

    protected TransportMessage() {
    }

    protected TransportMessage(TM message) {
        if (((TransportMessage)message).headers != null) {
            this.headers = new HashMap(((TransportMessage)message).headers);
        }
        this.copyContextFrom((HasContext)message);
    }

    public void remoteAddress(TransportAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public TransportAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public TransportMessage putHeader(String key, Object value) {
        return (TransportMessage)super.putHeader(key, value);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.headers = in.readBoolean() ? in.readMap() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.headers == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.headers);
        }
    }
}

