/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.termsstats.InternalTermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.doubles.TermsStatsDoubleFacetExecutor;
import org.elasticsearch.search.facet.termsstats.longs.TermsStatsLongFacetExecutor;
import org.elasticsearch.search.facet.termsstats.strings.TermsStatsStringFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public TermsStatsFacetParser(Settings settings) {
        super(settings);
        InternalTermsStatsFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"terms_stats", "termsStats"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String keyField = null;
        String valueField = null;
        int size = 10;
        int shardSize = -1;
        TermsStatsFacet.ComparatorType comparatorType = TermsStatsFacet.ComparatorType.COUNT;
        String scriptLang = null;
        String script = null;
        ScriptService.ScriptType scriptType = null;
        Map<String, Object> params = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentFieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("key_field".equals(currentFieldName) || "keyField".equals(currentFieldName)) {
                keyField = parser.text();
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_INLINE.match(currentFieldName) || ScriptService.SCRIPT_INLINE.match(currentFieldName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.INLINE;
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_ID.match(currentFieldName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.INDEXED;
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_FILE.match(currentFieldName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.FILE;
                continue;
            }
            if (ScriptService.SCRIPT_LANG.match(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("value_field".equals(currentFieldName) || "valueField".equals(currentFieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                size = parser.intValue();
                continue;
            }
            if ("shard_size".equals(currentFieldName) || "shardSize".equals(currentFieldName)) {
                shardSize = parser.intValue();
                continue;
            }
            if ("all_terms".equals(currentFieldName) || "allTerms".equals(currentFieldName)) {
                if (!parser.booleanValue()) continue;
                size = 0;
                continue;
            }
            if (!"order".equals(currentFieldName) && !"comparator".equals(currentFieldName)) continue;
            comparatorType = TermsStatsFacet.ComparatorType.fromString(parser.text());
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "[key_field] is required to be set for terms stats facet");
        }
        if (valueField == null && script == null) {
            throw new FacetPhaseExecutionException(facetName, "either [value_field] or [script] are required to be set for terms stats facet");
        }
        FieldMapper keyMapper = context.smartNameFieldMapper(keyField);
        if (keyMapper == null) {
            throw new FacetPhaseExecutionException(facetName, "failed to find mapping for " + keyField);
        }
        Object keyIndexFieldData = context.fieldData().getForField(keyMapper);
        if (shardSize < size) {
            shardSize = size;
        }
        IndexNumericFieldData valueIndexFieldData = null;
        SearchScript valueScript = null;
        if (valueField != null) {
            FieldMapper fieldMapper = context.smartNameFieldMapper(valueField);
            if (fieldMapper == null) {
                throw new FacetPhaseExecutionException(facetName, "failed to find mapping for " + valueField);
            }
            if (!(fieldMapper instanceof NumberFieldMapper)) {
                throw new FacetPhaseExecutionException(facetName, "value_field [" + valueField + "] isn't a number field, but a " + fieldMapper.fieldDataType().getType());
            }
            valueIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(fieldMapper);
        } else {
            valueScript = context.scriptService().search(context.lookup(), scriptLang, script, scriptType, ScriptContext.Standard.AGGS, params);
        }
        if (keyIndexFieldData instanceof IndexNumericFieldData) {
            IndexNumericFieldData keyIndexNumericFieldData = (IndexNumericFieldData)keyIndexFieldData;
            if (keyIndexNumericFieldData.getNumericType().isFloatingPoint()) {
                return new TermsStatsDoubleFacetExecutor(keyIndexNumericFieldData, valueIndexFieldData, valueScript, size, shardSize, comparatorType, context);
            }
            return new TermsStatsLongFacetExecutor(keyIndexNumericFieldData, valueIndexFieldData, valueScript, size, shardSize, comparatorType, context);
        }
        return new TermsStatsStringFacetExecutor((IndexFieldData)keyIndexFieldData, valueIndexFieldData, valueScript, size, shardSize, comparatorType, context);
    }
}

