/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractPercentilesParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class PercentilesParser
extends AbstractPercentilesParser {
    private static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};

    public PercentilesParser() {
        super(true);
    }

    @Override
    public String type() {
        return InternalPercentiles.TYPE.name();
    }

    @Override
    protected String keysFieldName() {
        return "percents";
    }

    @Override
    protected AggregatorFactory buildFactory(SearchContext context, String aggregationName, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double[] keys, double compression, boolean keyed) {
        if (keys == null) {
            keys = DEFAULT_PERCENTS;
        }
        return new PercentilesAggregator.Factory(aggregationName, valuesSourceConfig, keys, compression, keyed);
    }
}

