/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class DoubleTerms
extends InternalTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("terms", "dterms");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public DoubleTerms readResult(StreamInput in) throws IOException {
            DoubleTerms buckets = new DoubleTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };
    @Nullable
    private ValueFormatter formatter;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    DoubleTerms() {
    }

    public DoubleTerms(String name, Terms.Order order, @Nullable ValueFormatter formatter, int requiredSize, int shardSize, long minDocCount, List<InternalTerms.Bucket> buckets, boolean showTermDocCountError, long docCountError, long otherDocCount) {
        super(name, order, requiredSize, shardSize, minDocCount, buckets, showTermDocCountError, docCountError, otherDocCount);
        this.formatter = formatter;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected InternalTerms newAggregation(String name, List<InternalTerms.Bucket> buckets, boolean showTermDocCountError, long docCountError, long otherDocCount) {
        return new DoubleTerms(name, this.order, this.formatter, this.requiredSize, this.shardSize, this.minDocCount, buckets, showTermDocCountError, docCountError, otherDocCount);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.docCountError = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? in.readLong() : -1L;
        this.order = InternalOrder.Streams.readOrder(in);
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.requiredSize = DoubleTerms.readSize(in);
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.shardSize = DoubleTerms.readSize(in);
            this.showTermDocCountError = in.readBoolean();
        } else {
            this.shardSize = this.requiredSize;
            this.showTermDocCountError = false;
        }
        this.minDocCount = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_1_4_0)) {
            this.otherDocCount = in.readVLong();
        }
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            double term = in.readDouble();
            long docCount = in.readVLong();
            long bucketDocCountError = -1L;
            if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) && this.showTermDocCountError) {
                bucketDocCountError = in.readLong();
            }
            InternalAggregations aggregations = InternalAggregations.readAggregations(in);
            buckets.add(new Bucket(term, docCount, aggregations, this.showTermDocCountError, bucketDocCountError));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeLong(this.docCountError);
        }
        InternalOrder.Streams.writeOrder(this.order, out);
        ValueFormatterStreams.writeOptional(this.formatter, out);
        DoubleTerms.writeSize(this.requiredSize, out);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            DoubleTerms.writeSize(this.shardSize, out);
            out.writeBoolean(this.showTermDocCountError);
        }
        out.writeVLong(this.minDocCount);
        if (out.getVersion().onOrAfter(Version.V_1_4_0)) {
            out.writeVLong(this.otherDocCount);
        }
        out.writeVInt(this.buckets.size());
        for (InternalTerms.Bucket bucket : this.buckets) {
            out.writeDouble(((Bucket)bucket).term);
            out.writeVLong(bucket.getDocCount());
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1) && this.showTermDocCountError) {
                out.writeLong(bucket.docCountError);
            }
            ((InternalAggregations)bucket.getAggregations()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count_error_upper_bound", this.docCountError);
        builder.field("sum_other_doc_count", this.otherDocCount);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalTerms.Bucket bucket : this.buckets) {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, ((Bucket)bucket).term);
            if (this.formatter != null && this.formatter != ValueFormatter.RAW) {
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, this.formatter.format(((Bucket)bucket).term));
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.getDocCount());
            if (this.showTermDocCountError) {
                builder.field("doc_count_error_upper_bound", bucket.getDocCountError());
            }
            ((InternalAggregations)bucket.getAggregations()).toXContentInternal(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    static class Bucket
    extends InternalTerms.Bucket {
        double term;

        public Bucket(double term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError) {
            super(docCount, aggregations, showDocCountError, docCountError);
            this.term = term;
        }

        @Override
        public String getKey() {
            return String.valueOf(this.term);
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(String.valueOf(this.term));
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return Double.compare(this.term, other.getKeyAsNumber().doubleValue());
        }

        @Override
        Object getKeyAsObject() {
            return this.getKeyAsNumber();
        }

        @Override
        Bucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            return new Bucket(this.term, docCount, aggs, this.showDocCountError, docCountError);
        }
    }
}

