/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.flush;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.indices.flush.IndicesSyncedFlushResult;
import org.elasticsearch.indices.flush.SyncedFlushService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestSyncedFlushAction
extends BaseRestHandler {
    private final SyncedFlushService syncedFlushService;

    @Inject
    public RestSyncedFlushAction(Settings settings, RestController controller, Client client, SyncedFlushService syncedFlushService) {
        super(settings, controller, client);
        this.syncedFlushService = syncedFlushService;
        controller.registerHandler(RestRequest.Method.POST, "/_flush/synced", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_flush/synced", this);
        controller.registerHandler(RestRequest.Method.GET, "/_flush/synced", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_flush/synced", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(request, IndicesOptions.lenientExpandOpen());
        this.syncedFlushService.attemptSyncedFlush(indices, indicesOptions, (ActionListener<IndicesSyncedFlushResult>)new RestBuilderListener<IndicesSyncedFlushResult>(channel){

            @Override
            public RestResponse buildResponse(IndicesSyncedFlushResult results, XContentBuilder builder) throws Exception {
                builder.startObject();
                results.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(results.restStatus(), builder);
            }
        });
    }
}

