/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;

public class DeadlockAnalyzer {
    private static final Deadlock[] NULL_RESULT = new Deadlock[0];
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static DeadlockAnalyzer INSTANCE = new DeadlockAnalyzer();

    public static DeadlockAnalyzer deadlockAnalyzer() {
        return INSTANCE;
    }

    private DeadlockAnalyzer() {
    }

    public Deadlock[] findDeadlocks() {
        long[] deadlockedThreads = this.threadBean.findMonitorDeadlockedThreads();
        if (deadlockedThreads == null || deadlockedThreads.length == 0) {
            return NULL_RESULT;
        }
        ImmutableMap<Long, ThreadInfo> threadInfoMap = this.createThreadInfoMap(deadlockedThreads);
        Set<LinkedHashSet<ThreadInfo>> cycles = this.calculateCycles(threadInfoMap);
        Set<LinkedHashSet<ThreadInfo>> chains = this.calculateCycleDeadlockChains(threadInfoMap, cycles);
        cycles.addAll(chains);
        return this.createDeadlockDescriptions(cycles);
    }

    private Deadlock[] createDeadlockDescriptions(Set<LinkedHashSet<ThreadInfo>> cycles) {
        Deadlock[] result = new Deadlock[cycles.size()];
        int count = 0;
        for (LinkedHashSet<ThreadInfo> cycle : cycles) {
            ThreadInfo[] asArray = cycle.toArray(new ThreadInfo[cycle.size()]);
            Deadlock d = new Deadlock(asArray);
            result[count++] = d;
        }
        return result;
    }

    private Set<LinkedHashSet<ThreadInfo>> calculateCycles(ImmutableMap<Long, ThreadInfo> threadInfoMap) {
        HashSet<LinkedHashSet<ThreadInfo>> cycles = new HashSet<LinkedHashSet<ThreadInfo>>();
        for (Map.Entry entry : threadInfoMap.entrySet()) {
            LinkedHashSet<ThreadInfo> cycle = new LinkedHashSet<ThreadInfo>();
            ThreadInfo t = (ThreadInfo)entry.getValue();
            while (!cycle.contains(t)) {
                cycle.add(t);
                t = threadInfoMap.get(t.getLockOwnerId());
            }
            if (cycles.contains(cycle)) continue;
            cycles.add(cycle);
        }
        return cycles;
    }

    private Set<LinkedHashSet<ThreadInfo>> calculateCycleDeadlockChains(ImmutableMap<Long, ThreadInfo> threadInfoMap, Set<LinkedHashSet<ThreadInfo>> cycles) {
        ThreadInfo[] allThreads = this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds());
        HashSet<LinkedHashSet<ThreadInfo>> deadlockChain = new HashSet<LinkedHashSet<ThreadInfo>>();
        Set knownDeadlockedThreads = threadInfoMap.keySet();
        for (ThreadInfo threadInfo : allThreads) {
            Thread.State state = threadInfo.getThreadState();
            if (state != Thread.State.BLOCKED || knownDeadlockedThreads.contains(threadInfo.getThreadId())) continue;
            for (LinkedHashSet<ThreadInfo> cycle : cycles) {
                if (!cycle.contains(threadInfoMap.get(threadInfo.getLockOwnerId()))) continue;
                LinkedHashSet<ThreadInfo> chain = new LinkedHashSet<ThreadInfo>();
                ThreadInfo node = threadInfo;
                while (!chain.contains(node)) {
                    chain.add(node);
                    node = threadInfoMap.get(node.getLockOwnerId());
                }
                deadlockChain.add(chain);
            }
        }
        return deadlockChain;
    }

    private ImmutableMap<Long, ThreadInfo> createThreadInfoMap(long[] threadIds) {
        ThreadInfo[] threadInfos = this.threadBean.getThreadInfo(threadIds);
        ImmutableMap.Builder<Long, ThreadInfo> threadInfoMap = ImmutableMap.builder();
        for (ThreadInfo threadInfo : threadInfos) {
            threadInfoMap.put(threadInfo.getThreadId(), threadInfo);
        }
        return threadInfoMap.build();
    }

    public static class Deadlock {
        private final ThreadInfo[] members;
        private final String description;
        private final ImmutableSet<Long> memberIds;

        public Deadlock(ThreadInfo[] members) {
            this.members = members;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < members.length; ++x) {
                ThreadInfo ti = members[x];
                sb.append(ti.getThreadName());
                if (x < members.length) {
                    sb.append(" > ");
                }
                if (x == members.length - 1) {
                    sb.append(ti.getLockOwnerName());
                }
                builder.add((Object)ti.getThreadId());
            }
            this.description = sb.toString();
            this.memberIds = builder.build();
        }

        public ThreadInfo[] members() {
            return this.members;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Deadlock deadlock = (Deadlock)o;
            return !(this.memberIds != null ? !this.memberIds.equals(deadlock.memberIds) : deadlock.memberIds != null);
        }

        public int hashCode() {
            int result = this.members != null ? Arrays.hashCode(this.members) : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.memberIds != null ? this.memberIds.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.description;
        }
    }
}

