/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.IOException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.fs.FsStats;

public class FsService
extends AbstractComponent {
    private final FsProbe probe;
    private final SingleObjectCache<FsStats> fsStatsCache;

    @Inject
    public FsService(Settings settings, FsProbe probe) throws IOException {
        super(settings);
        this.probe = probe;
        TimeValue refreshInterval = settings.getAsTime("monitor.fs.refresh_interval", TimeValue.timeValueSeconds(1L));
        this.fsStatsCache = new FsStatsCache(refreshInterval, probe.stats());
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, refreshInterval);
    }

    public FsStats stats() {
        return this.fsStatsCache.getOrRefresh();
    }

    private class FsStatsCache
    extends SingleObjectCache<FsStats> {
        public FsStatsCache(TimeValue interval, FsStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected FsStats refresh() {
            try {
                return FsService.this.probe.stats();
            }
            catch (IOException ex) {
                FsService.this.logger.warn("Failed to fetch fs stats - returning empty instance", new Object[0]);
                return new FsStats();
            }
        }
    }
}

