/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStream;
import org.elasticsearch.index.translog.TranslogStreams;

public class LegacyTranslogStream
implements TranslogStream {
    LegacyTranslogStream() {
    }

    @Override
    public Translog.Operation read(StreamInput in) throws IOException {
        Translog.Operation.Type type = Translog.Operation.Type.fromId(in.readByte());
        Translog.Operation operation = TranslogStreams.newOperationFromType(type);
        operation.readFrom(in);
        return operation;
    }

    @Override
    public void write(StreamOutput out, Translog.Operation op) throws IOException {
        out.writeByte(op.opType().id());
        op.writeTo(out);
    }

    @Override
    public int writeHeader(FileChannel channel) {
        return 0;
    }

    @Override
    public StreamInput openInput(File translogFile) throws FileNotFoundException {
        return new InputStreamStreamInput(new FileInputStream(translogFile));
    }
}

