/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.distributor.Distributor;
import org.elasticsearch.index.store.distributor.LeastUsedDistributor;
import org.elasticsearch.index.store.distributor.RandomWeightedDistributor;

public class StoreModule
extends AbstractModule {
    public static final String DISTIBUTOR_KEY = "index.store.distributor";
    public static final String LEAST_USED_DISTRIBUTOR = "least_used";
    public static final String RANDOM_WEIGHT_DISTRIBUTOR = "random";
    private final Settings settings;
    private final IndexStore indexStore;
    private final ShardLock lock;
    private final Store.OnClose closeCallback;
    private Class<? extends Distributor> distributor;

    public StoreModule(Settings settings, IndexStore indexStore, ShardLock lock, Store.OnClose closeCallback) {
        this.indexStore = indexStore;
        this.settings = settings;
        this.lock = lock;
        this.closeCallback = closeCallback;
    }

    public void setDistributor(Class<? extends Distributor> distributor) {
        this.distributor = distributor;
    }

    @Override
    protected void configure() {
        this.bind(DirectoryService.class).to(this.indexStore.shardDirectory()).asEagerSingleton();
        this.bind(Store.class).asEagerSingleton();
        this.bind(ShardLock.class).toInstance(this.lock);
        this.bind(Store.OnClose.class).toInstance(this.closeCallback);
        if (this.distributor == null) {
            this.distributor = this.loadDistributor(this.settings);
        }
        this.bind(Distributor.class).to(this.distributor).asEagerSingleton();
    }

    private Class<? extends Distributor> loadDistributor(Settings settings) {
        String type = settings.get(DISTIBUTOR_KEY);
        Class distributor = LEAST_USED_DISTRIBUTOR.equals(type) ? LeastUsedDistributor.class : (RANDOM_WEIGHT_DISTRIBUTOR.equals(type) ? RandomWeightedDistributor.class : settings.getAsClass(DISTIBUTOR_KEY, LeastUsedDistributor.class, "org.elasticsearch.index.store.distributor.", "Distributor"));
        return distributor;
    }
}

