/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BlendedTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQuery
extends MatchQuery {
    private Float groupTieBreaker = null;
    private QueryBuilder queryBuilder;

    public void setTieBreaker(float tieBreaker) {
        this.groupTieBreaker = Float.valueOf(tieBreaker);
    }

    public MultiMatchQuery(QueryParseContext parseContext) {
        super(parseContext);
    }

    private Query parseAndApply(MatchQuery.Type type, String fieldName, Object value, String minimumShouldMatch, Float boostValue) throws IOException {
        Query query = this.parse(type, fieldName, value);
        if (query instanceof BooleanQuery) {
            Queries.applyMinimumShouldMatch((BooleanQuery)query, minimumShouldMatch);
        }
        if (boostValue != null && query != null) {
            query.setBoost(boostValue.floatValue());
        }
        return query;
    }

    public Query parse(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        if (fieldNames.size() == 1) {
            Map.Entry<String, Float> fieldBoost = fieldNames.entrySet().iterator().next();
            Float boostValue = fieldBoost.getValue();
            return this.parseAndApply(type.matchQueryType(), fieldBoost.getKey(), value, minimumShouldMatch, boostValue);
        }
        float tieBreaker = this.groupTieBreaker == null ? type.tieBreaker() : this.groupTieBreaker.floatValue();
        switch (type) {
            case PHRASE: 
            case PHRASE_PREFIX: 
            case BEST_FIELDS: 
            case MOST_FIELDS: {
                this.queryBuilder = new QueryBuilder(tieBreaker);
                break;
            }
            case CROSS_FIELDS: {
                this.queryBuilder = new CrossFieldsQueryBuilder(tieBreaker);
                break;
            }
            default: {
                throw new ElasticsearchIllegalStateException("No such type: " + (Object)((Object)type));
            }
        }
        List<Query> queries = this.queryBuilder.buildGroupedQueries(type, fieldNames, value, minimumShouldMatch);
        return this.queryBuilder.combineGrouped(queries);
    }

    @Override
    protected Query blendTermQuery(Term term, FieldMapper mapper) {
        if (this.queryBuilder == null) {
            return super.blendTermQuery(term, mapper);
        }
        return this.queryBuilder.blendTerm(term, mapper);
    }

    @Override
    protected boolean forceAnalyzeQueryString() {
        return this.queryBuilder == null ? super.forceAnalyzeQueryString() : this.queryBuilder.forceAnalyzeQueryString();
    }

    private static final class FieldAndMapper {
        final String field;
        final FieldMapper mapper;
        final float boost;

        private FieldAndMapper(String field, FieldMapper mapper, float boost) {
            this.field = field;
            this.mapper = mapper;
            this.boost = boost;
        }

        public Term newTerm(String value) {
            try {
                BytesRef bytesRef = this.mapper.indexedValueForSearch(value);
                return new Term(this.field, bytesRef);
            }
            catch (Exception exception) {
                return new Term(this.field, value);
            }
        }
    }

    public class CrossFieldsQueryBuilder
    extends QueryBuilder {
        private FieldAndMapper[] blendedFields;

        public CrossFieldsQueryBuilder(float tieBreaker) {
            super(false, tieBreaker);
        }

        @Override
        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            HashMap groups = new HashMap();
            ArrayList<Tuple<String, Float>> missing = new ArrayList<Tuple<String, Float>>();
            for (Map.Entry<String, Float> entry : fieldNames.entrySet()) {
                String string = entry.getKey();
                MapperService.SmartNameFieldMappers smartNameFieldMappers = MultiMatchQuery.this.parseContext.smartFieldMappers(string);
                if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
                    Float boost;
                    Analyzer actualAnalyzer = MultiMatchQuery.this.getAnalyzer(smartNameFieldMappers.mapper(), smartNameFieldMappers);
                    String string2 = smartNameFieldMappers.mapper().names().indexName();
                    if (!groups.containsKey(actualAnalyzer)) {
                        groups.put(actualAnalyzer, new ArrayList());
                    }
                    boost = (boost = entry.getValue()) == null ? Float.valueOf(1.0f) : boost;
                    ((List)groups.get(actualAnalyzer)).add(new FieldAndMapper(string2, smartNameFieldMappers.mapper(), boost.floatValue()));
                    continue;
                }
                missing.add(new Tuple<String, Float>(string, entry.getValue()));
            }
            ArrayList<Query> queries = new ArrayList<Query>();
            for (Tuple tuple : missing) {
                Query q = this.parseGroup(type.matchQueryType(), (String)tuple.v1(), (Float)tuple.v2(), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            for (List list : groups.values()) {
                if (list.size() > 1) {
                    this.blendedFields = new FieldAndMapper[list.size()];
                    int i = 0;
                    for (FieldAndMapper fieldAndMapper : list) {
                        this.blendedFields[i++] = fieldAndMapper;
                    }
                } else {
                    this.blendedFields = null;
                }
                FieldAndMapper fieldAndMapper = (FieldAndMapper)list.get(0);
                Query q = this.parseGroup(type.matchQueryType(), fieldAndMapper.field, Float.valueOf(1.0f), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            return queries.isEmpty() ? null : queries;
        }

        @Override
        public boolean forceAnalyzeQueryString() {
            return this.blendedFields != null;
        }

        @Override
        public Query blendTerm(Term term, FieldMapper mapper) {
            if (this.blendedFields == null) {
                return super.blendTerm(term, mapper);
            }
            Term[] terms = new Term[this.blendedFields.length];
            float[] blendedBoost = new float[this.blendedFields.length];
            for (int i = 0; i < this.blendedFields.length; ++i) {
                terms[i] = this.blendedFields[i].newTerm(term.text());
                blendedBoost[i] = this.blendedFields[i].boost;
            }
            if (MultiMatchQuery.this.commonTermsCutoff != null) {
                return BlendedTermQuery.commonTermsBlendedQuery(terms, blendedBoost, false, MultiMatchQuery.this.commonTermsCutoff.floatValue());
            }
            if (this.tieBreaker == 1.0f) {
                return BlendedTermQuery.booleanBlendedQuery(terms, blendedBoost, false);
            }
            return BlendedTermQuery.dismaxBlendedQuery(terms, blendedBoost, this.tieBreaker);
        }
    }

    public class QueryBuilder {
        protected final boolean groupDismax;
        protected final float tieBreaker;

        public QueryBuilder(float tieBreaker) {
            this(tieBreaker != 1.0f, tieBreaker);
        }

        public QueryBuilder(boolean groupDismax, float tieBreaker) {
            this.groupDismax = groupDismax;
            this.tieBreaker = tieBreaker;
        }

        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (String fieldName : fieldNames.keySet()) {
                Float boostValue = fieldNames.get(fieldName);
                Query query = this.parseGroup(type.matchQueryType(), fieldName, boostValue, value, minimumShouldMatch);
                if (query == null) continue;
                queries.add(query);
            }
            return queries;
        }

        public Query parseGroup(MatchQuery.Type type, String field, Float boostValue, Object value, String minimumShouldMatch) throws IOException {
            return MultiMatchQuery.this.parseAndApply(type, field, value, minimumShouldMatch, boostValue);
        }

        public Query combineGrouped(List<? extends Query> groupQuery) {
            if (groupQuery == null || groupQuery.isEmpty()) {
                return null;
            }
            if (groupQuery.size() == 1) {
                return groupQuery.get(0);
            }
            if (this.groupDismax) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.tieBreaker);
                for (Query query : groupQuery) {
                    disMaxQuery.add(query);
                }
                return disMaxQuery;
            }
            BooleanQuery booleanQuery = new BooleanQuery();
            for (Query query : groupQuery) {
                booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            return booleanQuery;
        }

        public Query blendTerm(Term term, FieldMapper mapper) {
            return MultiMatchQuery.super.blendTermQuery(term, mapper);
        }

        public boolean forceAnalyzeQueryString() {
            return false;
        }
    }
}

