/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.Lucene43EdgeNGramTokenizer;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class EdgeNGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int minGram;
    private final int maxGram;
    private final EdgeNGramTokenFilter.Side side;
    private Version esVersion;

    @Inject
    public EdgeNGramTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", (Integer)1);
        this.maxGram = settings.getAsInt("max_gram", (Integer)2);
        this.side = EdgeNGramTokenFilter.Side.getSide((String)settings.get("side", Lucene43EdgeNGramTokenizer.DEFAULT_SIDE.getLabel()));
        this.esVersion = Version.indexCreated(indexSettings);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.version.onOrAfter(org.apache.lucene.util.Version.LUCENE_43) && this.esVersion.onOrAfter(Version.V_0_90_2)) {
            org.apache.lucene.util.Version version = this.version == org.apache.lucene.util.Version.LUCENE_43 ? org.apache.lucene.util.Version.LUCENE_44 : this.version;
            TokenStream result = tokenStream;
            if (this.side == EdgeNGramTokenFilter.Side.BACK) {
                result = new ReverseStringFilter(version, result);
            }
            result = new EdgeNGramTokenFilter(version, result, this.minGram, this.maxGram);
            if (this.side == EdgeNGramTokenFilter.Side.BACK) {
                result = new ReverseStringFilter(version, result);
            }
            return result;
        }
        return new EdgeNGramTokenFilter(this.version, tokenStream, this.side, this.minGram, this.maxGram);
    }
}

