/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class QuerySourceBuilder
implements ToXContent {
    private QueryBuilder queryBuilder;
    private BytesReference queryBinary;

    public QuerySourceBuilder setQuery(QueryBuilder query) {
        this.queryBuilder = query;
        return this;
    }

    public QuerySourceBuilder setQuery(BytesReference queryBinary) {
        this.queryBinary = queryBinary;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.queryBinary != null) {
            if (XContentFactory.xContentType(this.queryBinary) == builder.contentType()) {
                builder.rawField("query", this.queryBinary);
            } else {
                builder.field("query_binary", this.queryBinary);
            }
        }
    }

    public BytesReference buildAsBytes(XContentType contentType) throws SearchSourceBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.bytes();
        }
        catch (Exception e) {
            throw new SearchSourceBuilderException("Failed to build search source", e);
        }
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON).prettyPrint();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.string();
        }
        catch (Exception e) {
            return "{ \"error\" : \"" + ExceptionsHelper.detailedMessage(e) + "\"}";
        }
    }
}

