/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSnapshotsAction
extends TransportMasterNodeOperationAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportGetSnapshotsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters) {
        super(settings, "cluster:admin/snapshot/get", transportService, clusterService, threadPool, actionFilters);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected String executor() {
        return "snapshot";
    }

    @Override
    protected GetSnapshotsRequest newRequest() {
        return new GetSnapshotsRequest();
    }

    @Override
    protected GetSnapshotsResponse newResponse() {
        return new GetSnapshotsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) throws ElasticsearchException {
        SnapshotId[] snapshotIds = new SnapshotId[request.snapshots().length];
        for (int i = 0; i < snapshotIds.length; ++i) {
            snapshotIds[i] = new SnapshotId(request.repository(), request.snapshots()[i]);
        }
        try {
            ImmutableList.Builder snapshotInfoBuilder = ImmutableList.builder();
            if (snapshotIds.length > 0) {
                for (SnapshotId snapshotId : snapshotIds) {
                    snapshotInfoBuilder.add(new SnapshotInfo(this.snapshotsService.snapshot(snapshotId)));
                }
            } else {
                ImmutableList<Snapshot> snapshots = this.snapshotsService.snapshots(request.repository());
                for (Snapshot snapshot : snapshots) {
                    snapshotInfoBuilder.add(new SnapshotInfo(snapshot));
                }
            }
            listener.onResponse(new GetSnapshotsResponse((ImmutableList<SnapshotInfo>)snapshotInfoBuilder.build()));
        }
        catch (Throwable t) {
            listener.onFailure(t);
        }
    }
}

