/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodesShutdownRequest;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodesShutdownResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportNodesShutdownAction
extends TransportMasterNodeOperationAction<NodesShutdownRequest, NodesShutdownResponse> {
    public static final String SHUTDOWN_NODE_ACTION_NAME = "cluster:admin/nodes/shutdown[n]";
    private final Node node;
    private final ClusterName clusterName;
    private final boolean disabled;
    private final TimeValue delay;

    @Inject
    public TransportNodesShutdownAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Node node, ClusterName clusterName, ActionFilters actionFilters) {
        super(settings, "cluster:admin/nodes/shutdown", transportService, clusterService, threadPool, actionFilters);
        this.node = node;
        this.clusterName = clusterName;
        this.disabled = settings.getAsBoolean("action.disable_shutdown", this.componentSettings.getAsBoolean("disabled", (Boolean)false));
        this.delay = this.componentSettings.getAsTime("delay", TimeValue.timeValueMillis(200L));
        this.transportService.registerHandler(SHUTDOWN_NODE_ACTION_NAME, new NodeShutdownRequestHandler());
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected ClusterBlockException checkBlock(NodesShutdownRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected NodesShutdownRequest newRequest() {
        return new NodesShutdownRequest();
    }

    @Override
    protected NodesShutdownResponse newResponse() {
        return new NodesShutdownResponse();
    }

    @Override
    protected void processBeforeDelegationToMaster(NodesShutdownRequest request, ClusterState state) {
        String[] nodesIds = request.nodesIds;
        if (nodesIds != null) {
            for (int i = 0; i < nodesIds.length; ++i) {
                if (!"_local".equals(nodesIds[i])) continue;
                nodesIds[i] = state.nodes().localNodeId();
            }
        }
    }

    @Override
    protected void masterOperation(final NodesShutdownRequest request, final ClusterState state, ActionListener<NodesShutdownResponse> listener) throws ElasticsearchException {
        if (this.disabled) {
            throw new ElasticsearchIllegalStateException("Shutdown is disabled");
        }
        final ObjectOpenHashSet<DiscoveryNode> nodes = new ObjectOpenHashSet<DiscoveryNode>();
        if (state.nodes().isAllNodes(request.nodesIds)) {
            this.logger.info("[cluster_shutdown]: requested, shutting down in [{}]", request.delay);
            nodes.addAll(state.nodes().dataNodes().values());
            nodes.addAll(state.nodes().masterNodes().values());
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(request.delay.millis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: stopping the cluster service so no re-routing will occur", new Object[0]);
                    TransportNodesShutdownAction.this.clusterService.stop();
                    final CountDownLatch latch = new CountDownLatch(nodes.size());
                    for (ObjectCursor cursor : nodes) {
                        final DiscoveryNode node = (DiscoveryNode)cursor.value;
                        if (node.id().equals(state.nodes().masterNodeId())) {
                            latch.countDown();
                            continue;
                        }
                        TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: sending shutdown request to [{}]", node);
                        TransportNodesShutdownAction.this.transportService.sendRequest(node, TransportNodesShutdownAction.SHUTDOWN_NODE_ACTION_NAME, new NodeShutdownRequest(request), new EmptyTransportResponseHandler("same"){

                            @Override
                            public void handleResponse(TransportResponse.Empty response) {
                                TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: received shutdown response from [{}]", node);
                                latch.countDown();
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                TransportNodesShutdownAction.this.logger.warn("[cluster_shutdown]: received failed shutdown response from [{}]", exp, node);
                                latch.countDown();
                            }
                        });
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TransportNodesShutdownAction.this.logger.info("[cluster_shutdown]: done shutting down all nodes except master, proceeding to master", new Object[0]);
                    TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: shutting down the master [{}]", state.nodes().masterNode());
                    TransportNodesShutdownAction.this.transportService.sendRequest(state.nodes().masterNode(), TransportNodesShutdownAction.SHUTDOWN_NODE_ACTION_NAME, new NodeShutdownRequest(request), new EmptyTransportResponseHandler("same"){

                        @Override
                        public void handleResponse(TransportResponse.Empty response) {
                            TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: received shutdown response from master", new Object[0]);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            TransportNodesShutdownAction.this.logger.warn("[cluster_shutdown]: received failed shutdown response master", exp, new Object[0]);
                        }
                    });
                }
            });
            t.start();
        } else {
            final String[] nodesIds = state.nodes().resolveNodesIds(request.nodesIds);
            this.logger.info("[partial_cluster_shutdown]: requested, shutting down [{}] in [{}]", nodesIds, request.delay);
            for (String nodeId : nodesIds) {
                DiscoveryNode node = state.nodes().get(nodeId);
                if (node == null) continue;
                nodes.add(node);
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(request.delay.millis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    final CountDownLatch latch = new CountDownLatch(nodesIds.length);
                    for (String nodeId : nodesIds) {
                        final DiscoveryNode node = state.nodes().get(nodeId);
                        if (node == null) {
                            TransportNodesShutdownAction.this.logger.warn("[partial_cluster_shutdown]: no node to shutdown for node_id [{}]", nodeId);
                            latch.countDown();
                            continue;
                        }
                        TransportNodesShutdownAction.this.logger.trace("[partial_cluster_shutdown]: sending shutdown request to [{}]", node);
                        TransportNodesShutdownAction.this.transportService.sendRequest(node, TransportNodesShutdownAction.SHUTDOWN_NODE_ACTION_NAME, new NodeShutdownRequest(request), new EmptyTransportResponseHandler("same"){

                            @Override
                            public void handleResponse(TransportResponse.Empty response) {
                                TransportNodesShutdownAction.this.logger.trace("[partial_cluster_shutdown]: received shutdown response from [{}]", node);
                                latch.countDown();
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                TransportNodesShutdownAction.this.logger.warn("[partial_cluster_shutdown]: received failed shutdown response from [{}]", exp, node);
                                latch.countDown();
                            }
                        });
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TransportNodesShutdownAction.this.logger.info("[partial_cluster_shutdown]: done shutting down [{}]", new Object[]{nodesIds});
                }
            });
            t.start();
        }
        listener.onResponse(new NodesShutdownResponse(this.clusterName, (DiscoveryNode[])nodes.toArray((Class)DiscoveryNode.class)));
    }

    static class NodeShutdownRequest
    extends TransportRequest {
        boolean exit;

        NodeShutdownRequest() {
        }

        NodeShutdownRequest(NodesShutdownRequest request) {
            super(request);
            this.exit = request.exit();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.exit = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.exit);
        }
    }

    private class NodeShutdownRequestHandler
    extends BaseTransportRequestHandler<NodeShutdownRequest> {
        private NodeShutdownRequestHandler() {
        }

        @Override
        public NodeShutdownRequest newInstance() {
            return new NodeShutdownRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(final NodeShutdownRequest request, TransportChannel channel) throws Exception {
            if (TransportNodesShutdownAction.this.disabled) {
                throw new ElasticsearchIllegalStateException("Shutdown is disabled");
            }
            TransportNodesShutdownAction.this.logger.info("shutting down in [{}]", TransportNodesShutdownAction.this.delay);
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(TransportNodesShutdownAction.this.delay.millis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!request.exit) {
                        TransportNodesShutdownAction.this.logger.info("initiating requested shutdown (no exit)...", new Object[0]);
                        try {
                            TransportNodesShutdownAction.this.node.close();
                        }
                        catch (Exception e) {
                            TransportNodesShutdownAction.this.logger.warn("Failed to shutdown", e, new Object[0]);
                        }
                        return;
                    }
                    boolean shutdownWithWrapper = false;
                    if (System.getProperty("elasticsearch-service") != null) {
                        try {
                            Class<?> wrapperManager = TransportNodesShutdownAction.this.settings.getClassLoader().loadClass("org.tanukisoftware.wrapper.WrapperManager");
                            TransportNodesShutdownAction.this.logger.info("initiating requested shutdown (using service)", new Object[0]);
                            wrapperManager.getMethod("stopAndReturn", Integer.TYPE).invoke(null, 0);
                            shutdownWithWrapper = true;
                        }
                        catch (Throwable e) {
                            TransportNodesShutdownAction.this.logger.error("failed to initial shutdown on service wrapper", e, new Object[0]);
                        }
                    }
                    if (!shutdownWithWrapper) {
                        TransportNodesShutdownAction.this.logger.info("initiating requested shutdown...", new Object[0]);
                        try {
                            TransportNodesShutdownAction.this.node.close();
                        }
                        catch (Exception e) {
                            TransportNodesShutdownAction.this.logger.warn("Failed to shutdown", e, new Object[0]);
                        }
                        finally {
                            System.exit(0);
                        }
                    }
                }
            });
            t.start();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }
}

