/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.primitives.Ints;

public abstract class BlendedTermQuery
extends Query {
    private final Term[] terms;
    private final float[] boosts;
    private volatile Term[] equalTerms = null;

    public BlendedTermQuery(Term[] terms, float[] boosts) {
        if (terms == null || terms.length == 0) {
            throw new IllegalArgumentException("terms must not be null or empty");
        }
        if (boosts != null && boosts.length != terms.length) {
            throw new IllegalArgumentException("boosts must have the same size as terms");
        }
        this.terms = terms;
        this.boosts = boosts;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        IndexReaderContext context = reader.getContext();
        TermContext[] ctx = new TermContext[this.terms.length];
        int[] docFreqs = new int[ctx.length];
        for (int i = 0; i < this.terms.length; ++i) {
            ctx[i] = TermContext.build((IndexReaderContext)context, (Term)this.terms[i]);
            docFreqs[i] = ctx[i].docFreq();
        }
        int maxDoc = reader.maxDoc();
        this.blend(ctx, maxDoc, reader);
        Query query = this.topLevelQuery(this.terms, ctx, docFreqs, maxDoc);
        query.setBoost(this.getBoost());
        return query;
    }

    protected abstract Query topLevelQuery(Term[] var1, TermContext[] var2, int[] var3, int var4);

    protected void blend(TermContext[] contexts, int maxDoc, IndexReader reader) throws IOException {
        if (contexts.length <= 1) {
            return;
        }
        int max = 0;
        long minSumTTF = Long.MAX_VALUE;
        for (int i = 0; i < contexts.length; ++i) {
            TermContext ctx = contexts[i];
            int df = ctx.docFreq();
            max = Math.max(df, max);
            minSumTTF = minSumTTF != -1L && ctx.totalTermFreq() != -1L ? Math.min(minSumTTF, reader.getSumTotalTermFreq(this.terms[i].field())) : -1L;
        }
        if (minSumTTF != -1L && (long)maxDoc > minSumTTF) {
            maxDoc = (int)minSumTTF;
        }
        if (max == 0) {
            return;
        }
        long sumTTF = minSumTTF == -1L ? -1L : 0L;
        Object[] tieBreak = new TermContext[contexts.length];
        System.arraycopy(contexts, 0, tieBreak, 0, contexts.length);
        ArrayUtil.timSort((Object[])tieBreak, (Comparator)new Comparator<TermContext>(){

            @Override
            public int compare(TermContext o1, TermContext o2) {
                return Ints.compare(o2.docFreq(), o1.docFreq());
            }
        });
        int prev = tieBreak[0].docFreq();
        int actualDf = Math.min(maxDoc, max);
        assert (actualDf >= 0) : "DF must be >= 0";
        for (Object ctx : tieBreak) {
            if (ctx.docFreq() == 0) break;
            int current = ctx.docFreq();
            if (prev > current) {
                ++actualDf;
            }
            ctx.setDocFreq(Math.min(maxDoc, actualDf));
            prev = current;
            if (sumTTF >= 0L && ctx.totalTermFreq() >= 0L) {
                sumTTF += ctx.totalTermFreq();
                continue;
            }
            sumTTF = -1L;
        }
        sumTTF = Math.min(sumTTF, minSumTTF);
        for (int i = 0; i < contexts.length; ++i) {
            int df = contexts[i].docFreq();
            if (df == 0) continue;
            long fixedTTF = sumTTF == -1L ? -1L : sumTTF;
            contexts[i] = this.adjustTTF(contexts[i], fixedTTF);
        }
    }

    private TermContext adjustTTF(TermContext termContext, long sumTTF) {
        if (sumTTF == -1L && termContext.totalTermFreq() == -1L) {
            return termContext;
        }
        TermContext newTermContext = new TermContext(termContext.topReaderContext);
        List leaves = termContext.topReaderContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        int df = termContext.docFreq();
        long ttf = sumTTF;
        for (int i = 0; i < len; ++i) {
            TermState termState = termContext.get(i);
            if (termState == null) continue;
            newTermContext.register(termState, i, df, ttf);
            df = 0;
            ttf = 0L;
        }
        return newTermContext;
    }

    public String toString(String field) {
        StringBuilder builder = new StringBuilder("blended(terms:[");
        for (int i = 0; i < this.terms.length; ++i) {
            builder.append(this.terms[i]);
            float boost = 1.0f;
            if (this.boosts != null) {
                boost = this.boosts[i];
            }
            builder.append(ToStringUtils.boost((float)boost));
            builder.append(", ");
        }
        if (this.terms.length > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("])");
        builder.append(ToStringUtils.boost((float)this.getBoost()));
        return builder.toString();
    }

    public void extractTerms(Set<Term> terms) {
        for (Term term : this.terms) {
            terms.add(term);
        }
    }

    private Term[] equalsTerms() {
        if (this.terms.length == 1) {
            return this.terms;
        }
        if (this.equalTerms == null) {
            Term[] t = new Term[this.terms.length];
            System.arraycopy(this.terms, 0, t, 0, this.terms.length);
            ArrayUtil.timSort((Comparable[])t);
            this.equalTerms = t;
        }
        return this.equalTerms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlendedTermQuery that = (BlendedTermQuery)((Object)o);
        return Arrays.equals(this.equalsTerms(), that.equalsTerms());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.equalsTerms());
        return result;
    }

    public static BlendedTermQuery booleanBlendedQuery(Term[] terms, boolean disableCoord) {
        return BlendedTermQuery.booleanBlendedQuery(terms, null, disableCoord);
    }

    public static BlendedTermQuery booleanBlendedQuery(Term[] terms, final float[] boosts, final boolean disableCoord) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermContext[] ctx, int[] docFreqs, int maxDoc) {
                BooleanQuery query = new BooleanQuery(disableCoord);
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery termQuery = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null) {
                        termQuery.setBoost(boosts[i]);
                    }
                    query.add((Query)termQuery, BooleanClause.Occur.SHOULD);
                }
                return query;
            }
        };
    }

    public static BlendedTermQuery commonTermsBlendedQuery(Term[] terms, final float[] boosts, final boolean disableCoord, final float maxTermFrequency) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermContext[] ctx, int[] docFreqs, int maxDoc) {
                BooleanQuery query = new BooleanQuery(true);
                BooleanQuery high = new BooleanQuery(disableCoord);
                BooleanQuery low = new BooleanQuery(disableCoord);
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery termQuery = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null) {
                        termQuery.setBoost(boosts[i]);
                    }
                    if (maxTermFrequency >= 1.0f && (float)docFreqs[i] > maxTermFrequency || docFreqs[i] > (int)Math.ceil(maxTermFrequency * (float)maxDoc)) {
                        high.add((Query)termQuery, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    low.add((Query)termQuery, BooleanClause.Occur.SHOULD);
                }
                if (low.clauses().isEmpty()) {
                    for (BooleanClause booleanClause : high) {
                        booleanClause.setOccur(BooleanClause.Occur.MUST);
                    }
                    return high;
                }
                if (high.clauses().isEmpty()) {
                    return low;
                }
                query.add((Query)high, BooleanClause.Occur.SHOULD);
                query.add((Query)low, BooleanClause.Occur.MUST);
                return query;
            }
        };
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, float tieBreakerMultiplier) {
        return BlendedTermQuery.dismaxBlendedQuery(terms, null, tieBreakerMultiplier);
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, final float[] boosts, final float tieBreakerMultiplier) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermContext[] ctx, int[] docFreqs, int maxDoc) {
                DisjunctionMaxQuery query = new DisjunctionMaxQuery(tieBreakerMultiplier);
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery termQuery = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null) {
                        termQuery.setBoost(boosts[i]);
                    }
                    query.add((Query)termQuery);
                }
                return query;
            }
        };
    }
}

