/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.support;

import com.sun.mail.imap.IMAPFolder;
import java.util.ArrayList;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.UIDFolder;

public class IMAPUtils {
    public static final FetchProfile FETCH_PROFILE_FLAGS_UID = new FetchProfile();
    public static final FetchProfile FETCH_PROFILE_HEAD = new FetchProfile();
    public static final FetchProfile FETCH_PROFILE_UID = new FetchProfile();

    public static void close(Folder folder) {
        try {
            if (folder != null && folder.isOpen()) {
                folder.close(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Store store) {
        try {
            if (store != null && store.isConnected()) {
                store.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void open(Folder folder) throws MessagingException {
        if (folder != null && folder.exists() && !folder.isOpen() && (folder.getType() & 1) != 0) {
            folder.open(1);
        }
    }

    public static String[] toStringArray(Flags flags) {
        ArrayList<String> flagsL = new ArrayList<String>(10);
        if (flags.contains(Flags.Flag.DELETED)) {
            flagsL.add("Deleted");
        }
        if (flags.contains(Flags.Flag.ANSWERED)) {
            flagsL.add("Answered");
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            flagsL.add("Draft");
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            flagsL.add("Flagged");
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            flagsL.add("Recent");
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            flagsL.add("Seen");
        }
        if (flags.contains(Flags.Flag.USER)) {
            String[] userFlags = flags.getUserFlags();
            for (int j = 0; j < userFlags.length; ++j) {
                flagsL.add(userFlags[j]);
            }
        }
        return flagsL.toArray(new String[flagsL.size()]);
    }

    static {
        FETCH_PROFILE_HEAD.add(FetchProfile.Item.ENVELOPE);
        FETCH_PROFILE_HEAD.add(FetchProfile.Item.CONTENT_INFO);
        FETCH_PROFILE_HEAD.add((FetchProfile.Item)IMAPFolder.FetchProfileItem.HEADERS);
        FETCH_PROFILE_FLAGS_UID.add(FetchProfile.Item.FLAGS);
        FETCH_PROFILE_FLAGS_UID.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        FETCH_PROFILE_UID.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
    }
}

