/*
 * Decompiled with CFR 0.152.
 */
package de.saly.elasticsearch.importer.imap.mailsource;

import com.sun.mail.pop3.POP3Folder;
import de.saly.elasticsearch.importer.imap.maildestination.MailDestination;
import de.saly.elasticsearch.importer.imap.mailsource.MailSource;
import de.saly.elasticsearch.importer.imap.state.State;
import de.saly.elasticsearch.importer.imap.state.StateManager;
import de.saly.elasticsearch.importer.imap.support.IMAPUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.indices.IndexMissingException;

public class ParallelPollingPOPMailSource
implements MailSource {
    private final ExecutorService es;
    private MailDestination mailDestination;
    private final String password;
    private final Properties props;
    private StateManager stateManager;
    private final int threadCount;
    private final String user;
    protected final ESLogger logger = ESLoggerFactory.getLogger((String)this.getClass().getName());
    private boolean deleteExpungedMessages = true;

    public ParallelPollingPOPMailSource(Properties props, int threadCount, String user, String password) {
        this.props = props;
        this.threadCount = threadCount < 1 ? 1 : threadCount;
        this.es = Executors.newFixedThreadPool(threadCount);
        this.user = user;
        this.password = password;
    }

    @Override
    public void close() {
        if (this.es != null) {
            this.logger.info("Initiate shutdown", new Object[0]);
            this.es.shutdown();
        }
    }

    @Override
    public void fetch(Pattern pattern) throws MessagingException, IOException {
        this.fetch(pattern, null);
    }

    @Override
    public void fetch(String folderName) throws MessagingException, IOException {
        this.fetch(null, folderName);
    }

    @Override
    public void fetchAll() throws MessagingException, IOException {
        this.fetch(null, null);
    }

    @Override
    public MailDestination getMailDestination() {
        return this.mailDestination;
    }

    public Properties getProps() {
        return this.props;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setMailDestination(MailDestination mailDestination) {
        this.mailDestination = mailDestination;
    }

    @Override
    public void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    @Override
    public void setDeleteExpungedMessages(boolean deleteExpungedMessages) {
        this.deleteExpungedMessages = deleteExpungedMessages;
    }

    private ProcessResult process(int messageCount, int start, final String folderName) {
        long startTime = System.currentTimeMillis();
        int netCount = messageCount - (start == 1 ? 0 : start);
        this.logger.debug("netCount: {}", new Object[]{netCount});
        if (netCount == 0) {
            return new ProcessResult(0, 0L);
        }
        int block = netCount / this.threadCount;
        ArrayList<Future<ProcessResult>> fl = new ArrayList<Future<ProcessResult>>();
        this.logger.debug(netCount + "/" + this.threadCount + "=" + block, new Object[0]);
        int lastStart = 0;
        for (int i = 1; i <= this.threadCount; ++i) {
            int _start;
            lastStart = _start = i == 1 ? start : lastStart + block + 1;
            final int n = Math.min(_start + block, messageCount);
            if (n < _start) continue;
            this.logger.debug("Schedule: " + _start + " - " + n, new Object[0]);
            Future<ProcessResult> f = this.es.submit(new Callable<ProcessResult>(){

                @Override
                public ProcessResult call() throws Exception {
                    return ParallelPollingPOPMailSource.this.processMessageSlice(_start, n, folderName);
                }
            });
            fl.add(f);
        }
        int processedCount = 0;
        for (Future future : fl) {
            try {
                processedCount += ((ProcessResult)future.get()).processedCount;
            }
            catch (Exception e) {
                this.logger.error("Unable to process some mails due to {}", (Throwable)e, new Object[]{e.toString()});
            }
        }
        long endTime = System.currentTimeMillis() + 1L;
        return new ProcessResult(processedCount, endTime - startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessResult processMessageSlice(int start, int end, String folderName) throws Exception {
        long startTime = System.currentTimeMillis();
        Store store = Session.getInstance((Properties)this.props).getStore();
        store.connect(this.user, this.password);
        Folder folder = store.getFolder(folderName);
        IMAPUtils.open(folder);
        try {
            Message[] msgs = folder.getMessages(start, end);
            folder.fetch(msgs, IMAPUtils.FETCH_PROFILE_HEAD);
            int processedCount = 0;
            for (Message m : msgs) {
                try {
                    this.mailDestination.onMessage(m);
                    ++processedCount;
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
                catch (Exception e) {
                    this.stateManager.onError("Unable to make indexable message", m, e);
                    this.logger.error("Unable to make indexable message due to {}", (Throwable)e, new Object[]{e.toString()});
                    IMAPUtils.open(folder);
                }
            }
            long endTime = System.currentTimeMillis() + 1L;
            ProcessResult processResult = new ProcessResult(processedCount, endTime - startTime);
            return processResult;
        }
        finally {
            IMAPUtils.close(folder);
            IMAPUtils.close(store);
        }
    }

    protected void fetch(Folder folder) throws MessagingException, IOException {
        if ((folder.getType() & 1) == 0) {
            this.logger.warn("Folder {} cannot hold messages", new Object[]{folder.getFullName()});
            return;
        }
        int messageCount = folder.getMessageCount();
        State riverState = this.stateManager.getRiverState(folder);
        this.logger.info("Fetch mails from folder {} ({})", new Object[]{folder.getURLName().toString(), messageCount});
        HashMap<String, Integer> serverMailSet = new HashMap<String, Integer>(messageCount);
        int highestMsgNum = 1;
        HashSet localMailSet = new HashSet();
        try {
            localMailSet = new HashSet(this.mailDestination.getCurrentlyStoredMessageUids(folder.getFullName(), true));
        }
        catch (IndexMissingException ime) {
            this.logger.debug(ime.toString(), new Object[0]);
        }
        if (messageCount > 0) {
            Message[] allmsg = folder.getMessages();
            folder.fetch(allmsg, IMAPUtils.FETCH_PROFILE_UID);
            for (Message m : allmsg) {
                try {
                    String uid = ((POP3Folder)folder).getUID(m);
                    serverMailSet.put(uid, m.getMessageNumber());
                }
                catch (Exception e) {
                    this.stateManager.onError("Unable to handle message ", m, e);
                    this.logger.error("Unable to handle message due to {}", (Throwable)e, new Object[]{e.toString()});
                    IMAPUtils.open(folder);
                }
            }
            try {
                for (Object retuid : localMailSet) {
                    Integer tmpNum = (Integer)serverMailSet.get(retuid);
                    if (tmpNum == null) continue;
                    highestMsgNum = Math.max(highestMsgNum, (Integer)serverMailSet.get(retuid));
                }
                this.logger.debug("highestMsgNum: {}", new Object[]{highestMsgNum});
            }
            catch (Exception e) {
                this.logger.error("Error evalutating new messages. Will download all ... due to {}", (Throwable)e, new Object[]{e.toString()});
            }
            ProcessResult result = this.process(messageCount, highestMsgNum, folder.getFullName());
            riverState.setLastCount(result.getProcessedCount());
            if (result.getProcessedCount() > 0) {
                riverState.setLastIndexed(new Date());
            }
            riverState.setLastTook(result.getTook());
            riverState.setLastSchedule(new Date());
            this.stateManager.setRiverState(riverState);
            this.logger.info("Processed {} mails", new Object[]{result.getProcessedCount()});
        } else {
            this.logger.debug("Mailbox empty", new Object[0]);
        }
        if (this.deleteExpungedMessages) {
            this.logger.debug("Check now " + localMailSet.size() + " mails for expunge", new Object[0]);
            localMailSet.removeAll(serverMailSet.keySet());
            this.logger.info(localMailSet.size() + " messages were locally deleted, because they are expunged on server.", new Object[0]);
            this.mailDestination.onMessageDeletes(localMailSet, folder.getFullName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetch(Pattern unusedPattern, String unusedFolderName) throws MessagingException, IOException {
        this.logger.debug("fetch() - folderName: {}", new Object[]{"INBOX"});
        Store store = Session.getInstance((Properties)this.props).getStore();
        store.connect(this.user, this.password);
        Folder folder = store.getDefaultFolder();
        try {
            if (!folder.exists()) {
                this.logger.error("Folder {} does not exist on the server", new Object[]{folder.getFullName()});
                return;
            }
            IMAPUtils.open(folder);
            this.recurseFolders(folder, null);
        }
        finally {
            IMAPUtils.close(folder);
            IMAPUtils.close(store);
        }
    }

    protected void recurseFolders(Folder folder, Pattern pattern) throws MessagingException, IOException {
        if (folder != null) {
            if (this.es == null || this.es.isShutdown() || this.es.isTerminated() || Thread.currentThread().isInterrupted()) {
                this.logger.warn("Stop processing of mails due to mail source is closed", new Object[0]);
                return;
            }
            if ((folder.getType() & 1) != 0) {
                if (pattern != null && !pattern.matcher(folder.getFullName()).matches()) {
                    this.logger.trace("Pattern {} does not match {}", new Object[]{pattern.pattern(), folder.getFullName()});
                    return;
                }
                IMAPUtils.open(folder);
                try {
                    this.fetch(folder);
                }
                finally {
                    IMAPUtils.close(folder);
                }
            }
            if ((folder.getType() & 2) != 0) {
                for (Folder subfolder : folder.list()) {
                    this.recurseFolders(subfolder, pattern);
                }
            }
        }
    }

    private static class ProcessResult {
        private final int processedCount;
        private final long took;

        public ProcessResult(int processedCount, long took) {
            this.processedCount = processedCount;
            this.took = took;
        }

        public int getProcessedCount() {
            return this.processedCount;
        }

        public long getTook() {
            return this.took;
        }
    }
}

