/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class GeoDistanceSortBuilder
extends SortBuilder {
    final String fieldName;
    private final List<GeoPoint> points = new ArrayList<GeoPoint>();
    private final List<String> geohashes = new ArrayList<String>();
    private GeoDistance geoDistance;
    private DistanceUnit unit;
    private SortOrder order;
    private String sortMode;
    private FilterBuilder nestedFilter;
    private String nestedPath;

    public GeoDistanceSortBuilder(String fieldName) {
        this.fieldName = fieldName;
    }

    public GeoDistanceSortBuilder point(double lat, double lon) {
        this.points.add(new GeoPoint(lat, lon));
        return this;
    }

    public GeoDistanceSortBuilder points(GeoPoint ... points) {
        this.points.addAll(Arrays.asList(points));
        return this;
    }

    public GeoDistanceSortBuilder geohashes(String ... geohashes) {
        this.geohashes.addAll(Arrays.asList(geohashes));
        return this;
    }

    public GeoDistanceSortBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistanceSortBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public GeoDistanceSortBuilder order(SortOrder order) {
        this.order = order;
        return this;
    }

    @Override
    public SortBuilder missing(Object missing) {
        return this;
    }

    public GeoDistanceSortBuilder sortMode(String sortMode) {
        this.sortMode = sortMode;
        return this;
    }

    public GeoDistanceSortBuilder setNestedFilter(FilterBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public GeoDistanceSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("_geo_distance");
        if (this.geohashes.size() == 0 && this.points.size() == 0) {
            throw new ElasticsearchParseException("No points provided for _geo_distance sort.");
        }
        builder.startArray(this.fieldName);
        for (GeoPoint point : this.points) {
            builder.value(point);
        }
        for (String geohash : this.geohashes) {
            builder.value(geohash);
        }
        builder.endArray();
        if (this.unit != null) {
            builder.field("unit", (Object)this.unit);
        }
        if (this.geoDistance != null) {
            builder.field("distance_type", this.geoDistance.name().toLowerCase(Locale.ROOT));
        }
        if (this.order == SortOrder.DESC) {
            builder.field("reverse", true);
        }
        if (this.sortMode != null) {
            builder.field("mode", this.sortMode);
        }
        if (this.nestedPath != null) {
            builder.field("nested_path", this.nestedPath);
        }
        if (this.nestedFilter != null) {
            builder.field("nested_filter", this.nestedFilter, params);
        }
        builder.endObject();
        return builder;
    }
}

