/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.uri;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.URIPattern;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class URLRepository
extends BlobStoreRepository {
    public static final String TYPE = "url";
    public static final String[] DEFAULT_SUPPORTED_PROTOCOLS = new String[]{"http", "https", "ftp", "file", "jar"};
    public static final String SUPPORTED_PROTOCOLS_SETTING = "repositories.url.supported_protocols";
    public static final String ALLOWED_URLS_SETTING = "repositories.url.allowed_urls";
    private final String[] supportedProtocols;
    private final URIPattern[] urlWhiteList;
    private final Environment environment;
    private final URLBlobStore blobStore;
    private final BlobPath basePath;
    private boolean listDirectories;

    @Inject
    public URLRepository(RepositoryName name, RepositorySettings repositorySettings, IndexShardRepository indexShardRepository, Environment environment) throws IOException {
        super(name.getName(), repositorySettings, indexShardRepository);
        String path = repositorySettings.settings().get(TYPE, this.componentSettings.get(TYPE));
        if (path == null) {
            throw new RepositoryException(name.name(), "missing url");
        }
        URL url = new URL(path);
        this.supportedProtocols = this.settings.getAsArray(SUPPORTED_PROTOCOLS_SETTING, DEFAULT_SUPPORTED_PROTOCOLS);
        String[] urlWhiteList = this.settings.getAsArray(ALLOWED_URLS_SETTING, Strings.EMPTY_ARRAY);
        this.urlWhiteList = new URIPattern[urlWhiteList.length];
        for (int i = 0; i < urlWhiteList.length; ++i) {
            this.urlWhiteList[i] = new URIPattern(urlWhiteList[i]);
        }
        this.environment = environment;
        this.listDirectories = repositorySettings.settings().getAsBoolean("list_directories", this.componentSettings.getAsBoolean("list_directories", (Boolean)true));
        URL normalizedURL = this.checkURL(url);
        this.blobStore = new URLBlobStore(this.componentSettings, normalizedURL);
        this.basePath = BlobPath.cleanPath();
    }

    @Override
    protected BlobStore blobStore() {
        return this.blobStore;
    }

    @Override
    protected BlobPath basePath() {
        return this.basePath;
    }

    @Override
    public ImmutableList<SnapshotId> snapshots() {
        if (this.listDirectories) {
            return super.snapshots();
        }
        try {
            return this.readSnapshotList();
        }
        catch (IOException ex) {
            throw new RepositoryException(this.repositoryName, "failed to get snapshot list in repository", ex);
        }
    }

    @Override
    public String startVerification() {
        return null;
    }

    @Override
    public void endVerification(String seed) {
        throw new UnsupportedOperationException("shouldn't be called");
    }

    private URL checkURL(URL url) {
        String protocol = url.getProtocol();
        if (protocol == null) {
            throw new RepositoryException(this.repositoryName, "unknown url protocol from URL [" + url + "]");
        }
        for (String supportedProtocol : this.supportedProtocols) {
            if (!supportedProtocol.equals(protocol)) continue;
            try {
                if (URIPattern.match(this.urlWhiteList, url.toURI())) {
                    return url;
                }
            }
            catch (URISyntaxException ex) {
                this.logger.warn("cannot parse the specified url [{}]", url);
                throw new RepositoryException(this.repositoryName, "cannot parse the specified url [" + url + "]");
            }
            URL normalizedUrl = this.environment.resolveRepoURL(url);
            if (normalizedUrl == null) {
                this.logger.warn("The specified url [{}] doesn't start with any repository paths specified by the path.repo setting: [{}] or by repositories.url.allowed_urls setting: [{}] ", url, this.environment.repoFiles());
                throw new RepositoryException(this.repositoryName, "file url [" + url + "] doesn't match any of the locations specified by path.repo or repositories.url.allowed_urls");
            }
            return normalizedUrl;
        }
        throw new RepositoryException(this.repositoryName, "unsupported url protocol [" + protocol + "] from URL [" + url + "]");
    }
}

