/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.logging.ESLogger;

public class RafReference {
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final AtomicInteger refCount = new AtomicInteger();
    private final ESLogger logger;

    public RafReference(File file, ESLogger logger) throws FileNotFoundException {
        this.logger = logger;
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.channel = this.raf.getChannel();
        this.refCount.incrementAndGet();
        logger.trace("created RAF reference for {}", file.getAbsolutePath());
    }

    public File file() {
        return this.file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public RandomAccessFile raf() {
        return this.raf;
    }

    public boolean increaseRefCount() {
        return this.refCount.incrementAndGet() > 1;
    }

    public void decreaseRefCount(boolean delete) {
        if (this.refCount.decrementAndGet() <= 0) {
            try {
                this.logger.trace("closing RAF reference delete: {} length: {} file: {}", delete, this.raf.length(), this.file.getAbsolutePath());
                this.raf.close();
                if (delete) {
                    this.file.delete();
                }
            }
            catch (IOException e) {
                this.logger.debug("failed to close RAF file", e, new Object[0]);
            }
        }
    }
}

