/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.RecoveryCounter;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.store.Store;

public final class FlushingRecoveryCounter
extends RecoveryCounter {
    private final Engine engine;
    private final ESLogger logger;
    private final Store store;

    FlushingRecoveryCounter(Engine engine, Store store, ESLogger logger) {
        super(store);
        this.engine = engine;
        this.logger = logger;
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int endRecovery() throws ElasticsearchException {
        this.store.incRef();
        try {
            int left = super.endRecovery();
            if (left == 0) {
                try {
                    this.engine.flush();
                }
                catch (FlushNotAllowedEngineException | IllegalIndexShardStateException indexShardException) {
                }
                catch (Throwable e) {
                    this.logger.warn("failed to flush shard post recovery", e, new Object[0]);
                }
            }
            int n = left;
            return n;
        }
        finally {
            this.store.decRef();
        }
    }
}

