/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.none;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.index.gateway.none.NoneIndexGatewayModule;

public class NoneGateway
extends AbstractLifecycleComponent<Gateway>
implements Gateway {
    public static final String TYPE = "none";
    private final ClusterName clusterName;

    @Inject
    public NoneGateway(Settings settings, ClusterName clusterName) {
        super(settings);
        this.clusterName = clusterName;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public String toString() {
        return "_none_";
    }

    @Override
    protected void doStart() throws ElasticsearchException {
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public void performStateRecovery(Gateway.GatewayStateRecoveredListener listener) throws GatewayException {
        this.logger.debug("performing state recovery", new Object[0]);
        listener.onSuccess(ClusterState.builder(this.clusterName).build());
    }

    @Override
    public Class<? extends Module> suggestIndexGateway() {
        return NoneIndexGatewayModule.class;
    }

    @Override
    public void reset() {
    }
}

