/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.Locale;
import org.apache.lucene.util.Constants;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.JNACLibrary;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.monitor.jvm.JvmInfo;

class JNANatives {
    private static final ESLogger logger = Loggers.getLogger(JNANatives.class);
    public static boolean LOCAL_MLOCKALL = false;

    JNANatives() {
    }

    static void tryMlockall() {
        int errno = Integer.MIN_VALUE;
        try {
            int result = JNACLibrary.mlockall(1);
            if (result != 0) {
                errno = Native.getLastError();
            } else {
                LOCAL_MLOCKALL = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            return;
        }
        if (errno != Integer.MIN_VALUE) {
            if (errno == 12 && System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux")) {
                logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out. Increase RLIMIT_MEMLOCK (ulimit).", new Object[0]);
            } else if (!System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
                logger.warn("Unknown mlockall error " + errno, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tryVirtualLock() {
        JNAKernel32Library kernel = JNAKernel32Library.getInstance();
        Pointer process = null;
        try {
            process = kernel.GetCurrentProcess();
            JNAKernel32Library.SizeT size = new JNAKernel32Library.SizeT(JvmInfo.jvmInfo().getMem().getHeapInit().getBytes() + 0x100000L);
            if (!kernel.SetProcessWorkingSetSize(process, size, size)) {
                logger.warn("Unable to lock JVM memory. Failed to set working set size. Error code " + Native.getLastError(), new Object[0]);
            } else {
                JNAKernel32Library.MemoryBasicInformation memInfo = new JNAKernel32Library.MemoryBasicInformation();
                long address = 0L;
                while (kernel.VirtualQueryEx(process, new Pointer(address), memInfo, memInfo.size()) != 0) {
                    boolean lockable;
                    boolean bl = lockable = memInfo.State.longValue() == 4096L && (memInfo.Protect.longValue() & 1L) != 1L && (memInfo.Protect.longValue() & 0x100L) != 256L;
                    if (lockable) {
                        kernel.VirtualLock(memInfo.BaseAddress, new JNAKernel32Library.SizeT(memInfo.RegionSize.longValue()));
                    }
                    address += memInfo.RegionSize.longValue();
                }
                LOCAL_MLOCKALL = true;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        finally {
            if (process != null) {
                kernel.CloseHandle(process);
            }
        }
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (Constants.WINDOWS) {
            try {
                boolean result = JNAKernel32Library.getInstance().addConsoleCtrlHandler(handler);
                if (result) {
                    logger.debug("console ctrl handler correctly set", new Object[0]);
                } else {
                    logger.warn("unknown error " + Native.getLastError() + " when adding console ctrl handler:", new Object[0]);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }
}

